/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.accurest.stubrunner.spring.cloud.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import io.codearte.accurest.stubrunner.RunningStubs;
import io.codearte.accurest.stubrunner.StubConfiguration;
import io.codearte.accurest.stubrunner.StubFinder;
import io.codearte.accurest.stubrunner.spring.cloud.StubMapperProperties;
import io.codearte.accurest.stubrunner.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class StubRunnerRibbonServerList
implements ServerList {
    private final ServerList<?> serverList;

    StubRunnerRibbonServerList(StubFinder stubFinder, final StubMapperProperties stubMapperProperties, IClientConfig clientConfig, final ServerList<?> delegate) {
        String serviceName = clientConfig.getClientName();
        String mappedServiceName = StringUtils.hasText((String)stubMapperProperties.fromServiceIdToIvyNotation(serviceName)) ? stubMapperProperties.fromServiceIdToIvyNotation(serviceName) : serviceName;
        RunningStubs runningStubs = stubFinder.findAllRunningStubs();
        final Map.Entry entry = runningStubs.getEntry(mappedServiceName);
        final ArrayList<1> servers = new ArrayList<1>();
        if (entry != null) {
            servers.add(new Server("localhost", (Integer)entry.getValue()){

                public Server.MetaInfo getMetaInfo() {
                    return new Server.MetaInfo(){

                        public String getAppName() {
                            return stubMapperProperties.fromIvyNotationToId(((StubConfiguration)entry.getKey()).toColonSeparatedDependencyNotation());
                        }

                        public String getServerGroup() {
                            return null;
                        }

                        public String getServiceIdForDiscovery() {
                            return stubMapperProperties.fromIvyNotationToId(((StubConfiguration)entry.getKey()).getArtifactId());
                        }

                        public String getInstanceId() {
                            return stubMapperProperties.fromIvyNotationToId(((StubConfiguration)entry.getKey()).getArtifactId());
                        }
                    };
                }
            });
        }
        this.serverList = new ServerList(){

            public List<?> getInitialListOfServers() {
                ArrayList combinedList = new ArrayList();
                combinedList.addAll(servers);
                combinedList.addAll(delegate.getInitialListOfServers());
                return combinedList;
            }

            public List<?> getUpdatedListOfServers() {
                ArrayList combinedList = new ArrayList();
                combinedList.addAll(servers);
                combinedList.addAll(delegate.getUpdatedListOfServers());
                return combinedList;
            }
        };
    }

    public List<?> getInitialListOfServers() {
        return this.serverList.getInitialListOfServers();
    }

    public List<?> getUpdatedListOfServers() {
        return this.serverList.getUpdatedListOfServers();
    }
}

