/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.match;

import codechicken.diffpatch.match.LineMatching;
import codechicken.diffpatch.util.LineRange;
import codechicken.repack.org.apache.commons.lang3.tuple.MutablePair;
import codechicken.repack.org.apache.commons.lang3.tuple.Pair;
import java.util.Arrays;
import java.util.List;

public class FuzzyLineMatcher {
    public static final float DEFAULT_MIN_MATCH_SCORE = 0.5f;
    public int maxMatchOffset = 5;
    public float minMatchScore = 0.5f;

    public void matchLinesByWords(int[] matches, List<String> wmLines1, List<String> wmLines2) {
        for (Pair<LineRange, LineRange> entry : LineMatching.unmatchedRanges(matches, wmLines2.size())) {
            LineRange range1 = entry.getLeft();
            LineRange range2 = entry.getRight();
            if (range1.getLength() == 0 || range2.getLength() == 0) continue;
            int[] match = this.match(wmLines1.subList(range1.getStart(), range1.getEnd()), wmLines2.subList(range2.getStart(), range2.getEnd()));
            for (int i = 0; i < match.length; ++i) {
                if (match[i] < 0) continue;
                matches[range1.getStart() + i] = range2.getStart() + match[i];
            }
        }
    }

    public int[] match(List<String> pattern, List<String> search) {
        Pair<Boolean, Float> pair;
        if (search.size() < pattern.size()) {
            int[] rMatch = this.match(search, pattern);
            int[] nMatch = new int[pattern.size()];
            Arrays.fill(nMatch, -1);
            for (int i = 0; i < rMatch.length; ++i) {
                if (rMatch[i] < 0) continue;
                nMatch[rMatch[i]] = i;
            }
            return nMatch;
        }
        if (pattern.size() == 0) {
            return new int[0];
        }
        float bestScore = this.minMatchScore;
        int[] bestMatch = null;
        MatchMatrix mm = new MatchMatrix(pattern, search, this.maxMatchOffset, null);
        int i = mm.workingRange.getFirst();
        while ((pair = mm.match(i)).getLeft().booleanValue()) {
            float score = pair.getRight().floatValue();
            if (score > bestScore) {
                bestScore = score;
                bestMatch = mm.path();
            }
            ++i;
        }
        if (bestMatch == null) {
            int[] ret = new int[pattern.size()];
            Arrays.fill(ret, -1);
            return ret;
        }
        return bestMatch;
    }

    public static float matchLines(String s, String t) {
        int d = FuzzyLineMatcher.levenshteinDistance(s, t);
        if (d == 0) {
            return 1.0f;
        }
        float max = (float)Math.max(s.length(), t.length()) / 2.0f;
        return Math.max(0.0f, 1.0f - (float)d / max);
    }

    public static int levenshteinDistance(String s, String t) {
        int i;
        if (s.equals(t)) {
            return 0;
        }
        if (s.length() == 0) {
            return t.length();
        }
        if (t.length() == 0) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (i = 0; i < v1.length; ++i) {
            v1[i] = i;
        }
        for (i = 0; i < s.length(); ++i) {
            int[] tmp = v0;
            v0 = v1;
            v1 = tmp;
            v1[0] = i + 1;
            for (int j = 0; j < t.length(); ++j) {
                int del = v0[j + 1] + 1;
                int ins = v1[j] + 1;
                int subs = v0[j] + (s.charAt(i) == t.charAt(j) ? 0 : 1);
                v1[j + 1] = Math.min(del, Math.min(ins, subs));
            }
        }
        return v1[t.length()];
    }

    public static class MatchMatrix {
        public static final int DEFAULT_MAX_OFFSET = 5;
        private final int patternLength;
        private final LineRange range;
        private final int maxOffset;
        public LineRange workingRange;
        private int pos = Integer.MIN_VALUE;
        private final StraightMatch[] matches;
        private int firstNode;

        public MatchMatrix(List<String> pattern, List<String> search) {
            this(pattern, search, 5, null);
        }

        public MatchMatrix(List<String> pattern, List<String> search, int maxOffset, LineRange range) {
            if (range == null) {
                range = LineRange.fromStartLen(0, search.size());
            }
            this.patternLength = pattern.size();
            this.range = range;
            this.maxOffset = maxOffset;
            this.workingRange = LineRange.fromFirstLast(range.getStart() - maxOffset, range.getEnd() - this.patternLength);
            this.matches = new StraightMatch[maxOffset + 1];
            for (int i = 0; i <= maxOffset; ++i) {
                this.matches[i] = new StraightMatch(pattern, search, range);
            }
        }

        public Pair<Boolean, Float> match(int loc) {
            MutablePair<Boolean, Float> ret = new MutablePair<Boolean, Float>();
            ret.setRight(Float.valueOf(0.0f));
            if (!this.workingRange.contains(loc)) {
                ret.setLeft(false);
                return ret;
            }
            if (loc == this.pos + 1) {
                this.stepForward();
            } else if (loc == this.pos - 1) {
                this.stepBackward();
            } else {
                this.init(loc);
            }
            ret.setRight(Float.valueOf(this.recalculate()));
            ret.setLeft(true);
            return ret;
        }

        private void init(int loc) {
            this.pos = loc;
            for (int i = 0; i <= this.maxOffset; ++i) {
                this.matches[i].update(loc + i);
            }
        }

        private void stepForward() {
            ++this.pos;
            StraightMatch reuse = this.matches[0];
            for (int i = 1; i <= this.maxOffset; ++i) {
                this.matches[i - 1] = this.matches[i];
            }
            this.matches[this.maxOffset] = reuse;
            reuse.update(this.pos + this.maxOffset);
        }

        private void stepBackward() {
            --this.pos;
            StraightMatch reuse = this.matches[this.maxOffset];
            for (int i = this.maxOffset; i > 0; --i) {
                this.matches[i] = this.matches[i - 1];
            }
            this.matches[0] = reuse;
            reuse.update(this.pos);
        }

        private float recalculate() {
            for (int j = 0; j <= this.maxOffset; ++j) {
                MatchNode node = this.matches[j].nodes[this.patternLength - 1];
                node.sum = node.score;
                node.next = -1;
            }
            for (int i = this.patternLength - 2; i >= 0; --i) {
                for (int j = 0; j <= this.maxOffset; ++j) {
                    MatchNode node = this.matches[j].nodes[i];
                    int maxk = -1;
                    float maxsum = 0.0f;
                    for (int k = 0; k <= this.maxOffset; ++k) {
                        int l = i + MatchMatrix.offsetsToPatternDistance(j, k);
                        if (l >= this.patternLength) continue;
                        float sum = this.matches[k].nodes[l].sum;
                        if (k > j) {
                            sum -= 0.5f * (float)(k - j);
                        }
                        if (!(sum > maxsum)) continue;
                        maxk = k;
                        maxsum = sum;
                    }
                    node.sum = maxsum + node.score;
                    node.next = maxk;
                }
            }
            this.firstNode = 0;
            float maxsum = this.matches[0].nodes[0].sum;
            for (int k = 1; k <= this.maxOffset; ++k) {
                float sum = this.matches[k].nodes[0].sum;
                if (!(sum > maxsum)) continue;
                this.firstNode = k;
                maxsum = sum;
            }
            return this.matches[this.firstNode].nodes[0].sum / (float)this.patternLength;
        }

        private int locInRange(int loc) {
            return this.range.contains(loc) ? loc : -1;
        }

        public int[] path() {
            int[] path = new int[this.patternLength];
            int offset = this.firstNode;
            MatchNode node = this.matches[this.firstNode].nodes[0];
            path[0] = this.locInRange(this.pos + offset);
            int i = 0;
            while (node.next >= 0) {
                int delta = MatchMatrix.offsetsToPatternDistance(offset, node.next);
                while (delta-- > 1) {
                    path[++i] = -1;
                }
                offset = node.next;
                node = this.matches[offset].nodes[++i];
                path[i] = this.locInRange(this.pos + i + offset);
            }
            while (++i < path.length) {
                path[i] = -1;
            }
            return path;
        }

        public String visualise() {
            int[] path = this.path();
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j <= this.maxOffset; ++j) {
                sb.append(j).append(':');
                StraightMatch line = this.matches[j];
                for (int i = 0; i < this.patternLength; ++i) {
                    boolean inPath = path[i] > 0 && path[i] == this.pos + i + j;
                    sb.append(inPath ? (char)'[' : ' ');
                    int score = Math.round(line.nodes[i].score * 100.0f);
                    sb.append(score == 100 ? "%%" : Integer.valueOf(score));
                    sb.append(inPath ? (char)']' : ' ');
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        private static int offsetsToPatternDistance(int i, int j) {
            return j >= i ? 1 : 1 + i - j;
        }

        private static class MatchNode {
            public float score;
            public float sum;
            public int next;

            private MatchNode() {
            }
        }

        private static class StraightMatch {
            private final int patternLength;
            private final List<String> pattern;
            private final List<String> search;
            private final LineRange range;
            public final MatchNode[] nodes;

            public StraightMatch(List<String> pattern, List<String> search, LineRange range) {
                this.patternLength = pattern.size();
                this.pattern = pattern;
                this.search = search;
                this.range = range;
                this.nodes = new MatchNode[this.patternLength];
                for (int i = 0; i < this.patternLength; ++i) {
                    this.nodes[i] = new MatchNode();
                }
            }

            public void update(int loc) {
                for (int i = 0; i < this.patternLength; ++i) {
                    int l = i + loc;
                    this.nodes[i].score = l < this.range.getStart() || l >= this.range.getEnd() ? 0.0f : FuzzyLineMatcher.matchLines(this.pattern.get(i), this.search.get(l));
                }
            }
        }
    }
}

