/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.diff;

import codechicken.diffpatch.diff.PatienceDiffer;
import codechicken.diffpatch.match.FuzzyLineMatcher;
import codechicken.diffpatch.util.CharRepresenter;
import java.util.List;
import net.covers1624.quack.collection.FastStream;

public class LineMatchedDiffer
extends PatienceDiffer {
    private List<String> wordModeLines1;
    private List<String> wordModeLines2;
    private int maxMatchOffset;
    private int minMatchScore;

    public LineMatchedDiffer() {
    }

    public LineMatchedDiffer(CharRepresenter charRep) {
        super(charRep);
    }

    @Override
    public int[] match(List<String> lines1, List<String> lines2) {
        int[] matches = super.match(lines1, lines2);
        this.wordModeLines1 = FastStream.of(lines1).map(this.charRep::wordsToChars).toList();
        this.wordModeLines2 = FastStream.of(lines2).map(this.charRep::wordsToChars).toList();
        FuzzyLineMatcher matcher = new FuzzyLineMatcher();
        matcher.maxMatchOffset = this.maxMatchOffset;
        matcher.minMatchScore = this.minMatchScore;
        matcher.matchLinesByWords(matches, this.wordModeLines1, this.wordModeLines2);
        return matches;
    }

    public List<String> getWordModeLines1() {
        return this.wordModeLines1;
    }

    public List<String> getWordModeLines2() {
        return this.wordModeLines2;
    }

    public int getMaxMatchOffset() {
        return this.maxMatchOffset;
    }

    public void setMaxMatchOffset(int maxMatchOffset) {
        this.maxMatchOffset = maxMatchOffset;
    }

    public int getMinMatchScore() {
        return this.minMatchScore;
    }

    public void setMinMatchScore(int minMatchScore) {
        this.minMatchScore = minMatchScore;
    }
}

