/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.match;

import codechicken.diffpatch.util.Diff;
import codechicken.diffpatch.util.LineRange;
import codechicken.diffpatch.util.Operation;
import codechicken.diffpatch.util.Patch;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class LineMatching {
    public static List<Pair<LineRange, LineRange>> unmatchedRanges(int[] matches, int len2) {
        ArrayList<Pair<LineRange, LineRange>> ret = new ArrayList<Pair<LineRange, LineRange>>();
        int len1 = matches.length;
        int start1 = 0;
        int start2 = 0;
        do {
            int end2;
            int end1;
            for (end1 = start1; end1 < len1 && matches[end1] < 0; ++end1) {
            }
            int n = end2 = end1 == len1 ? len2 : matches[end1];
            if (end1 != start1 || end2 != start2) {
                ret.add((Pair<LineRange, LineRange>)Pair.of((Object)new LineRange(start1, end1), (Object)new LineRange(start2, end2)));
                start1 = end1;
                start2 = end2;
                continue;
            }
            ++start1;
            ++start2;
        } while (start1 < len1 || start2 < len2);
        return ret;
    }

    public static int[] fromUnmatchedRanges(List<Pair<LineRange, LineRange>> unmatchedRanges, int len1) {
        int[] matches = new int[len1];
        int start1 = 0;
        int start2 = 0;
        for (Pair<LineRange, LineRange> entry : unmatchedRanges) {
            LineRange range1 = (LineRange)entry.getLeft();
            LineRange range2 = (LineRange)entry.getRight();
            while (start1 < range1.getStart()) {
                matches[start1++] = start2++;
            }
            if (start2 != range2.getStart()) {
                throw new IllegalArgumentException("Unequal number of lines between umatched ranges on each side");
            }
            while (start1 < range1.getEnd()) {
                matches[start1++] = -1;
            }
            start2 = range2.getEnd();
        }
        while (start1 < len1) {
            matches[start1++] = start2++;
        }
        return matches;
    }

    public static List<Pair<LineRange, LineRange>> unmatchedRanges(List<Patch> patches) {
        ArrayList<Pair<LineRange, LineRange>> ret = new ArrayList<Pair<LineRange, LineRange>>();
        for (Patch patch : patches) {
            List<Diff> diffs = patch.diffs;
            int start1 = patch.start1;
            int start2 = patch.start2;
            int i = 0;
            while (i < diffs.size()) {
                while (i < diffs.size() && diffs.get((int)i).op == Operation.EQUAL) {
                    ++start1;
                    ++start2;
                    ++i;
                }
                int end1 = start1;
                int end2 = start2;
                while (i < diffs.size() && diffs.get((int)i).op != Operation.EQUAL) {
                    if (diffs.get((int)i++).op == Operation.DELETE) {
                        ++end1;
                        continue;
                    }
                    ++end2;
                }
                if (end1 != start1 || end2 != start2) {
                    ret.add((Pair<LineRange, LineRange>)Pair.of((Object)new LineRange(start1, end1), (Object)new LineRange(start2, end2)));
                }
                start1 = end1;
                start2 = end2;
            }
        }
        return ret;
    }

    public static int[] fromPatches(List<Patch> patches, int len1) {
        return LineMatching.fromUnmatchedRanges(LineMatching.unmatchedRanges(patches), len1);
    }

    public static List<Diff> makeDiffList(int[] matches, List<String> lines1, List<String> lines2) {
        ArrayList<Diff> list = new ArrayList<Diff>();
        int l = 0;
        int r = 0;
        for (int i = 0; i < matches.length; ++i) {
            if (matches[i] < 0) continue;
            while (l < i) {
                list.add(new Diff(Operation.DELETE, lines1.get(l++)));
            }
            while (r < matches[i]) {
                list.add(new Diff(Operation.INSERT, lines2.get(r++)));
            }
            if (!lines1.get(l).equals(lines2.get(r))) {
                list.add(new Diff(Operation.DELETE, lines1.get(l)));
                list.add(new Diff(Operation.INSERT, lines2.get(r)));
            } else {
                list.add(new Diff(Operation.EQUAL, lines1.get(l)));
            }
            ++l;
            ++r;
        }
        while (l < lines1.size()) {
            list.add(new Diff(Operation.DELETE, lines1.get(l++)));
        }
        while (r < lines2.size()) {
            list.add(new Diff(Operation.INSERT, lines2.get(r++)));
        }
        return list;
    }
}

