/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util;

import codechicken.diffpatch.util.PatchMode;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import groovy.lang.Closure;
import java.io.File;
import java.util.Locale;
import java.util.function.Supplier;
import org.gradle.api.Project;

public class GradleUtil {
    public static File resolveFile(Project project, Object obj) {
        if (obj instanceof Closure) {
            return GradleUtil.resolveFile(project, ((Closure)obj).call());
        }
        if (obj instanceof Supplier) {
            return GradleUtil.resolveFile(project, ((Supplier)obj).get());
        }
        return project.file(obj);
    }

    public static PatchMode resolvePatchMode(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof PatchMode) {
            return (PatchMode)((Object)value);
        }
        if (value instanceof CharSequence) {
            String upper = value.toString().toUpperCase(Locale.ROOT);
            try {
                return PatchMode.valueOf(upper);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown PatchMode String value: " + value.toString());
            }
        }
        throw new IllegalArgumentException("Unable to parse PatchMode, Unknown value: " + value.toString());
    }

    public static ArchiveFormat resolveArchiveFormat(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof ArchiveFormat) {
            return (ArchiveFormat)((Object)value);
        }
        if (value instanceof CharSequence) {
            String upper = value.toString().toUpperCase(Locale.ROOT);
            try {
                return ArchiveFormat.valueOf(upper);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown ArchiveFormat String value: " + value.toString());
            }
        }
        throw new IllegalArgumentException("Unable to parse ArchiveFormat, Unknown value: " + value.toString());
    }
}

