/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util;

import codechicken.diffpatch.util.PathType;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.covers1624.quack.io.IOUtils;

public abstract class OutputPath {
    private final PathType type;

    public OutputPath(PathType type) {
        this.type = type;
    }

    public PathType getType() {
        return this.type;
    }

    public abstract boolean isFile();

    public abstract boolean exists();

    public abstract Path toPath();

    public abstract OutputStream open() throws IOException;

    public abstract String getName();

    public abstract ArchiveFormat getFormat();

    public static class NullPath
    extends OutputPath {
        public static final NullPath INSTANCE = new NullPath();

        public NullPath() {
            super(PathType.NULL);
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public Path toPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchiveFormat getFormat() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PipePath
    extends OutputPath {
        private final OutputStream pipe;
        private final ArchiveFormat format;

        public PipePath(OutputStream pipe, ArchiveFormat format) {
            super(PathType.PIPE);
            this.pipe = pipe;
            this.format = format;
        }

        @Override
        public OutputStream open() {
            return IOUtils.protectClose((OutputStream)this.pipe);
        }

        @Override
        public ArchiveFormat getFormat() {
            return this.format;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public Path toPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }
    }

    public static class FilePath
    extends OutputPath {
        private final Path path;
        private final ArchiveFormat format;
        private final OpenOption[] opts;

        public FilePath(Path path, ArchiveFormat format, OpenOption ... opts) {
            super(PathType.PATH);
            this.path = path.toAbsolutePath();
            this.format = format;
            this.opts = opts;
        }

        @Override
        public boolean isFile() {
            return Files.isRegularFile(this.path, new LinkOption[0]);
        }

        @Override
        public boolean exists() {
            return Files.exists(this.path, new LinkOption[0]);
        }

        @Override
        public Path toPath() {
            return this.path;
        }

        @Override
        public OutputStream open() throws IOException {
            if (Files.notExists(this.path.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            }
            return Files.newOutputStream(this.path, this.opts);
        }

        @Override
        public String getName() {
            return this.path.getFileName().toString();
        }

        @Override
        public ArchiveFormat getFormat() {
            return this.format;
        }
    }
}

