/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.cli;

import io.codechicken.diffpatch.cli.ArchiveFormatValueConverter;
import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.DiffOperation;
import io.codechicken.diffpatch.cli.PatchModeValueConverter;
import io.codechicken.diffpatch.cli.PatchOperation;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.PatchMode;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import io.codechicken.repack.joptsimple.AbstractOptionSpec;
import io.codechicken.repack.joptsimple.ArgumentAcceptingOptionSpec;
import io.codechicken.repack.joptsimple.NonOptionArgumentSpec;
import io.codechicken.repack.joptsimple.OptionParser;
import io.codechicken.repack.joptsimple.OptionSet;
import io.codechicken.repack.joptsimple.OptionSpec;
import io.codechicken.repack.joptsimple.OptionSpecBuilder;
import io.codechicken.repack.joptsimple.util.EnumConverter;
import io.codechicken.repack.joptsimple.util.PathConverter;
import io.codechicken.repack.joptsimple.util.PathProperties;
import io.codechicken.repack.net.covers1624.quack.util.SneakyUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class DiffPatchCli {
    public static void main(String[] args) throws IOException {
        System.exit(DiffPatchCli.mainI(args, System.err, System.out));
    }

    public static int mainI(String[] args, PrintStream logger, PrintStream pipe) throws IOException {
        CliOperation<?> operation = DiffPatchCli.parseOperation(logger, pipe, args);
        if (operation == null) {
            return -1;
        }
        return operation.operate().exit;
    }

    @VisibleForTesting
    @Nullable
    static CliOperation<?> parseOperation(PrintStream logger, PrintStream pipe, String ... args) throws IOException {
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
        AbstractOptionSpec helpOpt = parser.acceptsAll(Arrays.asList("h", "help"), "Prints this help.").forHelp();
        OptionSpecBuilder verboseOpt = parser.acceptsAll(Arrays.asList("v", "verbose"), "Prints more stuff. Alias for --log-level ALL");
        ArgumentAcceptingOptionSpec<LogLevel> logLevelOpt = parser.acceptsAll(Arrays.asList("l", "log-level"), "Set the Logging level.").availableUnless(verboseOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new EnumConverter<LogLevel>(LogLevel.class){}).defaultsTo(LogLevel.INFO, (LogLevel[])new LogLevel[0]);
        OptionSpecBuilder summaryOpt = parser.acceptsAll(Arrays.asList("s", "summary"), "Prints a changes summary at the end.");
        ArgumentAcceptingOptionSpec<Path> outputOpt = parser.acceptsAll(Arrays.asList("o", "output"), "Sets the output path.").withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec<ArchiveFormat> archiveOpt = parser.acceptsAll(Arrays.asList("A", "archive"), "Treat output as an archive. Allows printing multi-output to STDOUT.").withRequiredArg().withValuesConvertedBy(new ArchiveFormatValueConverter());
        ArgumentAcceptingOptionSpec<ArchiveFormat> baseArchiveOpt = parser.acceptsAll(Arrays.asList("B", "archive-base"), "Treat the base path as an archive.").withRequiredArg().withValuesConvertedBy(new ArchiveFormatValueConverter());
        ArgumentAcceptingOptionSpec<String> basePathPrefixOpt = parser.acceptsAll(Arrays.asList("base-path-prefix"), "The prefix to assume for paths of base files.").withRequiredArg().ofType(String.class).defaultsTo("a/", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> modifiedPathPrefixOpt = parser.acceptsAll(Arrays.asList("modified-path-prefix"), "The prefix to assume for paths of modified files.").withRequiredArg().ofType(String.class).defaultsTo("b/", (String[])new String[0]);
        OptionSpecBuilder doDiffOpt = parser.acceptsAll(Arrays.asList("d", "diff"), "Does a Diff operation.");
        OptionSpecBuilder autoHeaderOpt = parser.acceptsAll(Arrays.asList("h", "auto-header"), "Enables the generation of auto-headers. Using _ as the start2 index.").availableIf(doDiffOpt, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec<Integer> contextOpt = parser.acceptsAll(Arrays.asList("c", "context"), "Number of context lines to generate in diffs.").availableIf(doDiffOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo(3, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<ArchiveFormat> modifiedArchiveOpt = parser.acceptsAll(Arrays.asList("M", "archive-modified"), "Treat the modified path as an archive.").availableIf(doDiffOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new ArchiveFormatValueConverter());
        OptionSpecBuilder doPatchOpt = parser.acceptsAll(Arrays.asList("p", "patch"), "Does a Patch operation.");
        ArgumentAcceptingOptionSpec<Path> rejectOpt = parser.acceptsAll(Arrays.asList("r", "reject"), "Saves patch rejects to the specified path / archive").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec<ArchiveFormat> rejectArchiveOpt = parser.acceptsAll(Arrays.asList("H", "archive-rejects"), "Treat reject output as an archive.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new ArchiveFormatValueConverter());
        ArgumentAcceptingOptionSpec<Float> fuzzOpt = parser.acceptsAll(Arrays.asList("f", "fuzz"), "The minimum fuzz match quality, anything lower will be treated as a failure.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(Float.class).defaultsTo(Float.valueOf(0.5f), (Float[])new Float[0]);
        ArgumentAcceptingOptionSpec<Integer> offsetOpt = parser.acceptsAll(Arrays.asList("O", "offset"), "The max line offset allowed for fuzzy matching, larger than this will be treated as a failure.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo(5, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<PatchMode> modeOpt = parser.acceptsAll(Arrays.asList("m", "mode"), "The desired patching mode.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new PatchModeValueConverter()).defaultsTo(PatchMode.EXACT, (PatchMode[])new PatchMode[0]);
        ArgumentAcceptingOptionSpec<String> patchPrefix = parser.acceptsAll(Arrays.asList("P", "prefix"), "Prefix path for reading patches from patches input.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(String.class).defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<ArchiveFormat> patchesArchiveOpt = parser.acceptsAll(Arrays.asList("N", "archive-patches"), "Treat the patches path as an archive.").availableIf(doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new ArchiveFormatValueConverter());
        OptionSet optSet = parser.parse(args);
        if (optSet.has(helpOpt)) {
            parser.printHelpOn(logger);
            return null;
        }
        LogLevel level = optSet.valueOf(logLevelOpt);
        if (level == null) {
            level = optSet.has(summaryOpt) ? LogLevel.DEBUG : LogLevel.INFO;
        }
        boolean summary = optSet.has(summaryOpt);
        List<String> arguments = optSet.valuesOf(nonOptions);
        if (arguments.size() != 2) {
            logger.println("Expected 2 arguments, got: " + arguments.size());
            parser.printHelpOn(logger);
            return null;
        }
        if (optSet.has(doDiffOpt)) {
            Input.MultiInput aInput;
            Path aPath = Paths.get(arguments.get(0), new String[0]);
            Path bPath = Paths.get(arguments.get(1), new String[0]);
            Path outputPath = optSet.valueOf(outputOpt);
            ArchiveFormat aFormat = DiffPatchCli.detectFormat(optSet.valueOf(baseArchiveOpt), aPath);
            ArchiveFormat bFormat = DiffPatchCli.detectFormat(optSet.valueOf(modifiedArchiveOpt), bPath);
            ArchiveFormat outputFormat = DiffPatchCli.detectFormat(optSet.valueOf(archiveOpt), outputPath);
            String basePathPrefix = optSet.valueOf(basePathPrefixOpt);
            String modifiedPathPrefix = optSet.valueOf(modifiedPathPrefixOpt);
            Output output = outputFormat != null ? (outputPath != null ? Output.MultiOutput.archive(outputFormat, outputPath) : Output.MultiOutput.archive(outputFormat, pipe)) : (outputPath != null ? (Files.isDirectory(outputPath, new LinkOption[0]) ? Output.MultiOutput.folder(outputPath) : Output.SingleOutput.path(outputPath, new OpenOption[0])) : Output.SingleOutput.pipe(pipe));
            if (aFormat != null) {
                aInput = Input.MultiInput.archive(aFormat, aPath);
            } else {
                Input input = aInput = Files.isDirectory(aPath, new LinkOption[0]) ? Input.MultiInput.folder(aPath) : Input.SingleInput.path(aPath, new OpenOption[0]);
            }
            Input bInput = bFormat != null ? Input.MultiInput.archive(bFormat, bPath) : (Files.isDirectory(bPath, new LinkOption[0]) ? Input.MultiInput.folder(bPath) : Input.SingleInput.path(bPath, new OpenOption[0]));
            return DiffOperation.builder().logTo(logger).helpCallback(SneakyUtils.sneak(parser::printHelpOn)).baseInput(aInput).changedInput(bInput).patchesOutput(output).level(level).summary(summary).autoHeader(optSet.has(autoHeaderOpt)).context(optSet.valueOf(contextOpt)).aPrefix(basePathPrefix).bPrefix(modifiedPathPrefix).build();
        }
        if (optSet.has(doPatchOpt)) {
            Input.MultiInput patchesInput;
            Input.MultiInput baseInput;
            Path base = Paths.get(arguments.get(0), new String[0]);
            Path patches = Paths.get(arguments.get(1), new String[0]);
            Path outputPath = optSet.valueOf(outputOpt);
            Path rejectsPath = optSet.valueOf(rejectOpt);
            ArchiveFormat baseFormat = DiffPatchCli.detectFormat(optSet.valueOf(baseArchiveOpt), base);
            ArchiveFormat patchesFormat = DiffPatchCli.detectFormat(optSet.valueOf(patchesArchiveOpt), patches);
            ArchiveFormat outputFormat = DiffPatchCli.detectFormat(optSet.valueOf(archiveOpt), outputPath);
            ArchiveFormat rejectsFormat = DiffPatchCli.detectFormat(optSet.valueOf(rejectArchiveOpt), rejectsPath);
            String basePathPrefix = optSet.valueOf(basePathPrefixOpt);
            String modifiedPathPrefix = optSet.valueOf(modifiedPathPrefixOpt);
            if (baseFormat != null) {
                baseInput = Input.MultiInput.archive(baseFormat, base);
            } else {
                Input input = baseInput = Files.isDirectory(base, new LinkOption[0]) ? Input.MultiInput.folder(base) : Input.SingleInput.path(base, new OpenOption[0]);
            }
            if (patchesFormat != null) {
                patchesInput = Input.MultiInput.archive(patchesFormat, patches);
            } else {
                Input input = patchesInput = Files.isDirectory(patches, new LinkOption[0]) ? Input.MultiInput.folder(patches) : Input.SingleInput.path(patches, new OpenOption[0]);
            }
            Output output = outputFormat != null ? (outputPath != null ? Output.MultiOutput.archive(outputFormat, outputPath) : Output.MultiOutput.archive(outputFormat, pipe)) : (outputPath != null ? (Files.isDirectory(outputPath, new LinkOption[0]) ? Output.MultiOutput.folder(outputPath) : Output.SingleOutput.path(outputPath, new OpenOption[0])) : Output.SingleOutput.pipe(pipe));
            Output rejects = null;
            if (rejectsPath != null) {
                rejects = rejectsFormat != null ? Output.MultiOutput.archive(rejectsFormat, rejectsPath) : (Files.isDirectory(rejectsPath, new LinkOption[0]) ? Output.MultiOutput.folder(rejectsPath) : Output.SingleOutput.path(rejectsPath, new OpenOption[0]));
            }
            return PatchOperation.builder().logTo(logger).helpCallback(SneakyUtils.sneak(parser::printHelpOn)).level(level).summary(summary).baseInput(baseInput).patchesInput(patchesInput).patchedOutput(output).rejectsOutput(rejects).minFuzz(optSet.valueOf(fuzzOpt).floatValue()).maxOffset(optSet.valueOf(offsetOpt)).mode(optSet.valueOf(modeOpt)).patchesPrefix(optSet.valueOf(patchPrefix)).aPrefix(basePathPrefix).bPrefix(modifiedPathPrefix).build();
        }
        logger.println("Expected --diff or --patch.");
        parser.printHelpOn(logger);
        return null;
    }

    @Nullable
    private static ArchiveFormat detectFormat(@Nullable ArchiveFormat existing, @Nullable Path detectFrom) {
        if (existing != null) {
            return existing;
        }
        if (detectFrom != null) {
            return ArchiveFormat.findFormat(detectFrom.getFileName());
        }
        return null;
    }
}

