/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.joptsimple.util;

import io.codechicken.repack.joptsimple.ValueConversionException;
import io.codechicken.repack.joptsimple.ValueConverter;
import io.codechicken.repack.joptsimple.internal.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class InetAddressConverter
implements ValueConverter<InetAddress> {
    @Override
    public InetAddress convert(String value) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new ValueConversionException(this.message(value));
        }
    }

    @Override
    public Class<InetAddress> valueType() {
        return InetAddress.class;
    }

    @Override
    public String valuePattern() {
        return null;
    }

    private String message(String value) {
        return Messages.message(Locale.getDefault(), "io.codechicken.repack.joptsimple.ExceptionMessages", InetAddressConverter.class, "message", value);
    }
}

