/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.joptsimple.util;

import io.codechicken.repack.joptsimple.ValueConversionException;
import io.codechicken.repack.joptsimple.ValueConverter;
import io.codechicken.repack.joptsimple.internal.Messages;
import java.util.Locale;
import java.util.regex.Pattern;

public class RegexMatcher
implements ValueConverter<String> {
    private final Pattern pattern;

    public RegexMatcher(String pattern, int flags) {
        this.pattern = Pattern.compile(pattern, flags);
    }

    public static ValueConverter<String> regex(String pattern) {
        return new RegexMatcher(pattern, 0);
    }

    @Override
    public String convert(String value) {
        if (!this.pattern.matcher(value).matches()) {
            this.raiseValueConversionFailure(value);
        }
        return value;
    }

    @Override
    public Class<String> valueType() {
        return String.class;
    }

    @Override
    public String valuePattern() {
        return this.pattern.pattern();
    }

    private void raiseValueConversionFailure(String value) {
        String message = Messages.message(Locale.getDefault(), "io.codechicken.repack.joptsimple.ExceptionMessages", RegexMatcher.class, "message", value, this.pattern.pattern());
        throw new ValueConversionException(message);
    }
}

