/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.collection.redblack;

import io.codechicken.repack.net.covers1624.quack.collection.redblack.BaseRedBlackTree;
import io.codechicken.repack.net.covers1624.quack.collection.redblack.ContainerNode;
import io.codechicken.repack.net.covers1624.quack.collection.redblack.RedBlackNode;
import io.codechicken.repack.net.covers1624.quack.collection.redblack.SimpleRedBlackTree;
import io.codechicken.repack.net.covers1624.quack.util.Object2IntFunction;
import io.codechicken.repack.net.covers1624.quack.util.SneakyUtils;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.Nullable;

public class RedBlackList<T extends Comparable<T>>
extends SimpleRedBlackTree<T, Node>
implements List<T> {
    @Override
    protected Node newNode(T value) {
        return new Node(this, value);
    }

    public Node nodeAt(int index) {
        return RedBlackList.getByIndex(this, index, Node::getCount);
    }

    public int indexOf(@Nullable Node node) {
        return RedBlackList.indexOf(this, node, Node::getCount);
    }

    @Override
    public T get(int index) {
        return (T)this.nodeAt((int)index).value;
    }

    @Override
    public T set(int index, T element) {
        Node at = this.nodeAt(index);
        this.replace(at, this.newNode(element));
        return (T)at.value;
    }

    @Override
    public void add(int index, T element) {
        if (index == this.size()) {
            this.insertAt(null, true, this.newNode(element));
        } else {
            this.insertAt(this.nodeAt(index), false, this.newNode(element));
        }
    }

    @Override
    public T remove(int index) {
        Node thing = this.nodeAt(index);
        this.entries().remove(thing);
        return (T)thing.value;
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Comparable)) {
            return -1;
        }
        return this.indexOf((Node)this.find((Comparable)SneakyUtils.unsafeCast(o)));
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    public static <N extends RedBlackNode<N>> N getByIndex(BaseRedBlackTree<N> tree, int index, Object2IntFunction<N> countGetter) {
        if (index < 0 || index >= tree.count) {
            throw new IndexOutOfBoundsException("Got: " + index + ", Range: [0.." + tree.count + "]");
        }
        N node = tree.getRoot();
        assert (node != null);
        while (true) {
            if (((RedBlackNode)node).getLeft() != null && index < countGetter.apply(((RedBlackNode)node).getLeft())) {
                node = ((RedBlackNode)node).getLeft();
                continue;
            }
            if (((RedBlackNode)node).getRight() == null) {
                return node;
            }
            if ((index -= countGetter.apply(node) - countGetter.apply(((RedBlackNode)node).getRight())) < 0) {
                return node;
            }
            node = ((RedBlackNode)node).getRight();
        }
    }

    public static <N extends RedBlackNode<N>> int indexOf(BaseRedBlackTree<N> tree, @Nullable N node, Object2IntFunction<N> countGetter) {
        int index;
        if (node == null) {
            return -1;
        }
        assert (node.getRoot() == node);
        int n = index = node.getLeft() != null ? countGetter.apply(node.getLeft()) : 0;
        while (node.getParent() != null) {
            if (node.getSide()) {
                index += countGetter.apply(node.getParent()) - countGetter.apply(node);
            }
            node = node.getParent();
        }
        return index;
    }

    public static class Node
    extends ContainerNode<T, Node> {
        int count;
        final /* synthetic */ RedBlackList this$0;

        public Node(T value) {
            this.this$0 = this$0;
            super(value);
            this.count = 1;
        }

        @Override
        public void onChildrenChanged() {
            int count = 1;
            if (this.getLeft() != null) {
                count += ((Node)this.getLeft()).count;
            }
            if (this.getRight() != null) {
                count += ((Node)this.getRight()).count;
            }
            if (this.count != count) {
                this.count = count;
                if (this.getParent() != null) {
                    ((Node)this.getParent()).onChildrenChanged();
                }
            }
        }

        public int getCount() {
            return this.count;
        }
    }
}

