/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;

public class ByteArraySeekableChannel
implements SeekableByteChannel {
    private byte[] buf;
    private int pos;
    private int last;
    private boolean open = true;

    public ByteArraySeekableChannel() {
        this(32);
    }

    public ByteArraySeekableChannel(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    @Override
    public int read(ByteBuffer dst) {
        if (this.pos == this.buf.length) {
            return -1;
        }
        int toRead = Math.min(this.buf.length - this.pos, dst.remaining());
        dst.put(this.buf, this.pos, toRead);
        this.pos += toRead;
        return toRead;
    }

    @Override
    public int write(ByteBuffer src) {
        int toRead = src.remaining();
        this.fitBuffer(this.pos + toRead);
        src.get(this.buf, this.pos, toRead);
        this.pos += toRead;
        this.last = Math.max(this.last, this.pos);
        return toRead;
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public SeekableByteChannel position(long newPosition) {
        this.pos = (int)newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.last;
    }

    private void fitBuffer(int desiredCap) {
        if (desiredCap - this.buf.length <= 0) {
            return;
        }
        int oldCap = this.buf.length;
        int newCap = oldCap << 1;
        if (newCap - desiredCap < 0) {
            newCap = desiredCap;
        }
        this.buf = Arrays.copyOf(this.buf, newCap);
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.open = false;
    }
}

