/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class WriterOutputStream
extends OutputStream {
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(128);
    private final CharBuffer charBuffer = CharBuffer.allocate(1024);
    private final Writer writer;
    private final CharsetDecoder decoder;
    private final boolean autoFlush;

    public WriterOutputStream(Writer writer) {
        this(writer, StandardCharsets.UTF_8);
    }

    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, charset, true);
    }

    public WriterOutputStream(Writer writer, boolean autoFlush) {
        this(writer, StandardCharsets.UTF_8, autoFlush);
    }

    public WriterOutputStream(Writer writer, Charset charset, boolean autoFlush) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), autoFlush);
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder, boolean autoFlush) {
        this.writer = writer;
        this.decoder = decoder;
        this.autoFlush = autoFlush;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int min = Math.min(len, this.byteBuffer.remaining());
            this.byteBuffer.put(b, off, min);
            this.handleBytes(true);
            len -= min;
            off += min;
        }
        if (this.autoFlush) {
            this.flushInternal();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.handleBytes(false);
        this.flushInternal();
        this.writer.close();
    }

    private void handleBytes(boolean hasMore) throws IOException {
        this.byteBuffer.flip();
        while (true) {
            CoderResult result;
            if ((result = this.decoder.decode(this.byteBuffer, this.charBuffer, !hasMore)).isOverflow()) {
                this.flushInternal();
                continue;
            }
            if (result.isUnderflow()) break;
            result.throwException();
        }
        this.byteBuffer.compact();
    }

    private void flushInternal() throws IOException {
        if (this.charBuffer.position() <= 0) {
            return;
        }
        this.writer.write(this.charBuffer.array(), 0, this.charBuffer.position());
        this.charBuffer.rewind();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }
}

