/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.logging.log4j2;

import io.codechicken.repack.net.covers1624.quack.annotation.Requires;
import io.codechicken.repack.net.covers1624.quack.io.ConsumingOutputStream;
import io.codechicken.repack.org.apache.logging.log4j.Logger;
import java.io.PrintStream;

@Requires(value="io.codechicken.repack.org.apache.logging.log4j:log4j-api")
public class TracingPrintStream
extends PrintStream {
    private static final int BASE_DEPTH = 4;
    private final Logger logger;

    public TracingPrintStream(Logger logger) {
        super(new ConsumingOutputStream(line -> logger.info("{}{}", (Object)TracingPrintStream.getPrefix(), line)), true);
        this.logger = logger;
    }

    private void log(String s) {
        this.logger.info("{}{}", (Object)TracingPrintStream.getPrefix(), (Object)s);
    }

    private static String getPrefix() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        StackTraceElement elem = elems[Math.min(4, elems.length - 1)];
        if (elem.getClassName().startsWith("kotlin.io.")) {
            elem = elems[Math.min(6, elems.length - 1)];
        } else if (elem.getClassName().startsWith("java.lang.Throwable")) {
            elem = elems[Math.min(8, elems.length - 1)];
        }
        return "[" + elem.getClassName() + ":" + elem.getMethodName() + ":" + elem.getLineNumber() + "]: ";
    }

    @Override
    public void println(Object o) {
        this.log(String.valueOf(o));
    }

    @Override
    public void println(String s) {
        this.log(s);
    }

    @Override
    public void println(boolean x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(double x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.log(String.valueOf(x));
    }
}

