/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.net.httpapi;

import io.codechicken.repack.net.covers1624.quack.io.ByteArrayReadableChannel;
import io.codechicken.repack.net.covers1624.quack.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public interface WebBody {
    public InputStream open() throws IOException;

    default public ReadableByteChannel openChannel() throws IOException {
        return Channels.newChannel(this.open());
    }

    public boolean multiOpenAllowed();

    public long length();

    @Nullable
    public String contentType();

    default public byte[] asBytes() throws IOException {
        try (InputStream is = this.open();){
            byte[] byArray = IOUtils.toBytes(is);
            return byArray;
        }
    }

    default public String asString() throws IOException {
        return this.asString(StandardCharsets.UTF_8);
    }

    default public String asString(Charset charset) throws IOException {
        return new String(this.asBytes(), charset);
    }

    public static WebBody string(String str) {
        return WebBody.string(str, (String)null);
    }

    public static WebBody string(String str, @Nullable String contentType) {
        return WebBody.string(str, StandardCharsets.UTF_8, contentType);
    }

    public static WebBody string(String str, Charset charset) {
        return WebBody.string(str, charset, null);
    }

    public static WebBody string(String str, Charset charset, @Nullable String contentType) {
        return WebBody.bytes(str.getBytes(charset), contentType);
    }

    public static WebBody bytes(byte[] bytes) {
        return new BytesBody(bytes, null);
    }

    public static WebBody bytes(byte[] bytes, @Nullable String contentType) {
        return new BytesBody(bytes, contentType);
    }

    public static WebBody path(Path path) {
        return new PathBody(path, null);
    }

    public static WebBody path(Path path, @Nullable String contentType) {
        return new PathBody(path, contentType);
    }

    public static class PathBody
    implements WebBody {
        public final Path path;
        @Nullable
        private final String contentType;

        public PathBody(Path path, @Nullable String contentType) {
            this.path = path;
            this.contentType = contentType;
        }

        @Override
        public InputStream open() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public ReadableByteChannel openChannel() throws IOException {
            return Files.newByteChannel(this.path, new OpenOption[0]);
        }

        @Override
        public boolean multiOpenAllowed() {
            return true;
        }

        @Override
        public long length() {
            try {
                return Files.size(this.path);
            }
            catch (IOException ex) {
                return -1L;
            }
        }

        @Override
        @Nullable
        public String contentType() {
            return this.contentType;
        }
    }

    public static class BytesBody
    implements WebBody {
        private final byte[] bytes;
        @Nullable
        private final String contentType;

        public BytesBody(byte[] bytes, @Nullable String contentType) {
            this.bytes = bytes;
            this.contentType = contentType;
        }

        @Override
        public InputStream open() {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public ReadableByteChannel openChannel() {
            return new ByteArrayReadableChannel(this.bytes);
        }

        @Override
        public boolean multiOpenAllowed() {
            return true;
        }

        @Override
        public long length() {
            return this.bytes.length;
        }

        @Override
        @Nullable
        public String contentType() {
            return this.contentType;
        }
    }
}

