/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public class JavaPathUtils {
    private static final String EXE_SUFFIX = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win") ? ".exe" : "";
    private static final Path JAVA_HOME = JavaPathUtils.calcJavaHome();

    public static Path getJavaHome() {
        return JAVA_HOME;
    }

    public static Path getExecutable(String executableName) {
        return JavaPathUtils.getJavaHome().resolve("bin/" + executableName + EXE_SUFFIX);
    }

    public static Path getJavaExecutable() {
        return JavaPathUtils.getExecutable("java");
    }

    public static Path getJarSignerExecutable() {
        return JavaPathUtils.getExecutable("jarsigner");
    }

    private static Path calcJavaHome() {
        Path home = Paths.get(System.getProperty("java.home"), new String[0]).toAbsolutePath().normalize();
        if (home.getFileName().toString().equalsIgnoreCase("jre") && Files.exists(home.getParent().resolve("bin/java" + EXE_SUFFIX), new LinkOption[0])) {
            return home.getParent();
        }
        return home;
    }
}

