/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.codechicken.repack.net.covers1624.quack.annotation.Requires;
import io.codechicken.repack.net.covers1624.quack.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.WillNotClose;
import org.jetbrains.annotations.Nullable;

@Requires(value="com.google.guava:guava")
public class MultiHasher {
    private final Map<HashFunc, Hasher> hashers = new HashMap<HashFunc, Hasher>();
    private boolean finished;

    public MultiHasher(HashFunc ... hashFunctions) {
        this(Arrays.asList(hashFunctions));
    }

    public MultiHasher(Collection<HashFunc> hashFunctions) {
        if (hashFunctions.isEmpty()) {
            throw new IllegalArgumentException("Expected one or more hash functions.");
        }
        for (HashFunc func : hashFunctions) {
            this.hashers.put(func, func.newHasher());
        }
    }

    public HashResult finish() {
        if (this.finished) {
            throw new IllegalStateException("MultiHasher already finished.");
        }
        HashMap<HashFunc, HashCode> ret = new HashMap<HashFunc, HashCode>();
        for (Map.Entry<HashFunc, Hasher> entry : this.hashers.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().hash());
        }
        this.finished = true;
        return new HashResult(ret);
    }

    public void load(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            this.load(is);
        }
    }

    public void load(@WillNotClose InputStream is) throws IOException {
        int len;
        byte[] buffer = IOUtils.getCachedBuffer();
        while ((len = is.read(buffer)) != -1) {
            this.update(buffer, 0, len);
        }
    }

    public void update(byte[] bytes) {
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] bytes, int offset, int len) {
        for (Hasher hasher : this.hashers.values()) {
            hasher.putBytes(bytes, offset, len);
        }
    }

    public static final class HashFunc {
        private static final Map<String, HashFunc> HASH_FUNCS = new HashMap<String, HashFunc>();
        private static final Map<HashFunction, HashFunc> FUNC_FUNCS = new HashMap<HashFunction, HashFunc>();
        public static final HashFunc MD5 = HashFunc.create("MD5", Hashing.md5());
        public static final HashFunc SHA1 = HashFunc.create("SHA1", Hashing.sha1());
        public static final HashFunc SHA256 = HashFunc.create("SHA256", Hashing.sha256());
        public static final HashFunc SHA512 = HashFunc.create("SHA512", Hashing.sha512());
        public final String name;
        public final HashFunction hashFunction;

        private HashFunc(String name, HashFunction hashFunction) {
            this.name = Objects.requireNonNull(name);
            this.hashFunction = Objects.requireNonNull(hashFunction);
        }

        public static HashFunc create(String name, HashFunction hashFunction) {
            HashFunc func = HASH_FUNCS.get(name);
            if (func != null && func.hashFunction != hashFunction) {
                throw new IllegalArgumentException("Tried to re-register existing HashFunc with different Guava HashFunction. Got: " + hashFunction + ", Expected: " + func.hashFunction);
            }
            func = new HashFunc(name, hashFunction);
            HASH_FUNCS.put(name, func);
            FUNC_FUNCS.put(hashFunction, func);
            return func;
        }

        @Nullable
        public static HashFunc find(String name) {
            return HASH_FUNCS.get(name);
        }

        @Nullable
        public static HashFunc find(HashFunction func) {
            return FUNC_FUNCS.get(func);
        }

        public Map<String, HashFunc> getAllFuncs() {
            return Collections.unmodifiableMap(HASH_FUNCS);
        }

        public String getName() {
            return this.name;
        }

        public HashFunction getHashFunction() {
            return this.hashFunction;
        }

        public Hasher newHasher() {
            return this.hashFunction.newHasher();
        }
    }

    public static class HashResult
    extends AbstractMap<HashFunc, HashCode> {
        private final Map<HashFunc, HashCode> hashes;

        public HashResult(Map<HashFunc, HashCode> hashes) {
            this.hashes = ImmutableMap.copyOf(hashes);
        }

        public Set<HashFunc> findInvalidHashes(HashResult other) {
            HashSet<HashFunc> invalidHashes = new HashSet<HashFunc>();
            for (Map.Entry<HashFunc, HashCode> entry : this.entrySet()) {
                if (entry.getValue().equals(other.get(entry.getKey()))) continue;
                invalidHashes.add(entry.getKey());
            }
            return invalidHashes;
        }

        @Override
        public Set<Map.Entry<HashFunc, HashCode>> entrySet() {
            return this.hashes.entrySet();
        }
    }
}

