/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.org.tukaani.xz;

import io.codechicken.repack.org.tukaani.xz.ArrayCache;
import io.codechicken.repack.org.tukaani.xz.FinishableOutputStream;
import io.codechicken.repack.org.tukaani.xz.LZMA2Options;
import io.codechicken.repack.org.tukaani.xz.UnsupportedOptionsException;
import io.codechicken.repack.org.tukaani.xz.XZIOException;
import io.codechicken.repack.org.tukaani.xz.lz.LZEncoder;
import io.codechicken.repack.org.tukaani.xz.lzma.LZMAEncoder;
import io.codechicken.repack.org.tukaani.xz.rangecoder.RangeEncoderToStream;
import java.io.IOException;
import java.io.OutputStream;

public class LZMAOutputStream
extends FinishableOutputStream {
    private OutputStream out;
    private final ArrayCache arrayCache;
    private LZEncoder lz;
    private final RangeEncoderToStream rc;
    private LZMAEncoder lzma;
    private final int props;
    private final boolean useEndMarker;
    private final long expectedUncompressedSize;
    private long currentUncompressedSize = 0L;
    private boolean finished = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    private LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, boolean bl, boolean bl2, long l, ArrayCache arrayCache) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (l < -1L) {
            throw new IllegalArgumentException("Invalid expected input size (less than -1)");
        }
        this.useEndMarker = bl2;
        this.expectedUncompressedSize = l;
        this.arrayCache = arrayCache;
        this.out = outputStream;
        this.rc = new RangeEncoderToStream(outputStream);
        int n = lZMA2Options.getDictSize();
        this.lzma = LZMAEncoder.getInstance(this.rc, lZMA2Options.getLc(), lZMA2Options.getLp(), lZMA2Options.getPb(), lZMA2Options.getMode(), n, 0, lZMA2Options.getNiceLen(), lZMA2Options.getMatchFinder(), lZMA2Options.getDepthLimit(), arrayCache);
        this.lz = this.lzma.getLZEncoder();
        byte[] byArray = lZMA2Options.getPresetDict();
        if (byArray != null && byArray.length > 0) {
            if (bl) {
                throw new UnsupportedOptionsException("Preset dictionary cannot be used in .lzma files (try a raw LZMA stream instead)");
            }
            this.lz.setPresetDict(n, byArray);
        }
        this.props = (lZMA2Options.getPb() * 5 + lZMA2Options.getLp()) * 9 + lZMA2Options.getLc();
        if (bl) {
            int n2;
            outputStream.write(this.props);
            for (n2 = 0; n2 < 4; ++n2) {
                outputStream.write(n & 0xFF);
                n >>>= 8;
            }
            for (n2 = 0; n2 < 8; ++n2) {
                outputStream.write((int)(l >>> 8 * n2) & 0xFF);
            }
        }
    }

    public LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, long l) throws IOException {
        this(outputStream, lZMA2Options, l, ArrayCache.getDefaultCache());
    }

    public LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, long l, ArrayCache arrayCache) throws IOException {
        this(outputStream, lZMA2Options, true, l == -1L, l, arrayCache);
    }

    public LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, boolean bl) throws IOException {
        this(outputStream, lZMA2Options, bl, ArrayCache.getDefaultCache());
    }

    public LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, boolean bl, ArrayCache arrayCache) throws IOException {
        this(outputStream, lZMA2Options, false, bl, -1L, arrayCache);
    }

    public int getProps() {
        return this.props;
    }

    public long getUncompressedSize() {
        return this.currentUncompressedSize;
    }

    public void write(int n) throws IOException {
        this.tempBuf[0] = (byte)n;
        this.write(this.tempBuf, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        if (this.expectedUncompressedSize != -1L && this.expectedUncompressedSize - this.currentUncompressedSize < (long)n2) {
            throw new XZIOException("Expected uncompressed input size (" + this.expectedUncompressedSize + " bytes) was exceeded");
        }
        this.currentUncompressedSize += (long)n2;
        try {
            while (n2 > 0) {
                int n3 = this.lz.fillWindow(byArray, n, n2);
                n += n3;
                n2 -= n3;
                this.lzma.encodeForLZMA1();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void flush() throws IOException {
        throw new XZIOException("LZMAOutputStream does not support flushing");
    }

    public void finish() throws IOException {
        if (!this.finished) {
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                if (this.expectedUncompressedSize != -1L && this.expectedUncompressedSize != this.currentUncompressedSize) {
                    throw new XZIOException("Expected uncompressed size (" + this.expectedUncompressedSize + ") doesn't equal " + "the number of bytes written to the stream (" + this.currentUncompressedSize + ")");
                }
                this.lz.setFinishing();
                this.lzma.encodeForLZMA1();
                if (this.useEndMarker) {
                    this.lzma.encodeLZMA1EndMarker();
                }
                this.rc.finish();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
            this.lzma.putArraysToCache(this.arrayCache);
            this.lzma = null;
            this.lz = null;
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            block6: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block6;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

