/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.google.common.annotations.VisibleForTesting;
import io.codemodder.LineIncludesExcludes;
import io.codemodder.PathMatcher;
import java.io.File;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public interface IncludesExcludes {
    public boolean shouldInspect(File var1);

    public LineIncludesExcludes getIncludesExcludesForFile(File var1);

    public static IncludesExcludes withSettings(File repositoryRoot, List<String> includePatterns, List<String> excludePatterns) {
        Objects.requireNonNull(repositoryRoot, "repositoryRoot");
        Objects.requireNonNull(includePatterns, "includePatterns");
        Objects.requireNonNull(includePatterns, "excludePatterns");
        if (IncludesExcludes.noPatternsSpecified(includePatterns, excludePatterns)) {
            return new MatchesEverything();
        }
        ArrayList<PathMatcher> pathIncludes = new ArrayList<PathMatcher>();
        ArrayList<PathMatcher> pathExcludes = new ArrayList<PathMatcher>();
        for (String includePattern : includePatterns) {
            pathIncludes.add(IncludesExcludes.parsePattern(repositoryRoot, includePattern));
        }
        for (String excludePattern : excludePatterns) {
            pathExcludes.add(IncludesExcludes.parsePattern(repositoryRoot, excludePattern));
        }
        return new Default(pathIncludes, pathExcludes);
    }

    @VisibleForTesting
    public static PathMatcher parsePattern(File repositoryRoot, String pattern) {
        Integer line;
        Object pathPatternPart;
        int lineSeparatorIndex;
        Objects.requireNonNull(pattern);
        pattern = ((String)pattern).trim();
        if (!((String)pattern).startsWith("/")) {
            pattern = "/" + (String)pattern;
        }
        if ((lineSeparatorIndex = ((String)pattern).indexOf(58)) != -1) {
            pathPatternPart = ((String)pattern).substring(0, lineSeparatorIndex);
            line = Integer.parseInt(((String)pattern).substring(lineSeparatorIndex + 1));
        } else {
            pathPatternPart = pattern;
            line = null;
        }
        try {
            return new PathMatcher(FileSystems.getDefault(), repositoryRoot, (String)pathPatternPart, line);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("couldn't get canonical path", e);
        }
    }

    private static boolean noPatternsSpecified(List<String> includePatterns, List<String> excludePatterns) {
        return includePatterns.isEmpty() && excludePatterns.isEmpty();
    }

    public static IncludesExcludes any() {
        return new MatchesEverything();
    }

    public static class MatchesEverything
    implements IncludesExcludes {
        @Override
        public boolean shouldInspect(File file) {
            return true;
        }

        @Override
        public LineIncludesExcludes getIncludesExcludesForFile(File file) {
            return new LineIncludesExcludes.MatchesEverything();
        }
    }

    public static class Default
    implements IncludesExcludes {
        private final List<PathMatcher> pathIncludes;
        private final List<PathMatcher> pathExcludes;

        public Default(List<PathMatcher> pathIncludes, List<PathMatcher> pathExcludes) {
            this.pathIncludes = pathIncludes;
            this.pathExcludes = pathExcludes;
        }

        @Override
        public boolean shouldInspect(File file) {
            if ("pom.xml".equalsIgnoreCase(file.getName())) {
                return true;
            }
            if (!this.pathIncludes.isEmpty()) {
                for (PathMatcher pathInclude : this.pathIncludes) {
                    if (!pathInclude.matches(file)) continue;
                    for (PathMatcher pathExclude : this.pathExcludes) {
                        if (!pathExclude.matches(file) || pathExclude.targetsLine()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            for (PathMatcher pathExclude : this.pathExcludes) {
                if (pathExclude.targetsLine() || !pathExclude.matches(file)) continue;
                return false;
            }
            return true;
        }

        @Override
        public LineIncludesExcludes getIncludesExcludesForFile(File file) {
            HashSet<Integer> allowedLines = new HashSet<Integer>();
            for (PathMatcher pathInclude : this.pathIncludes) {
                if (!pathInclude.targetsLine() || !pathInclude.matches(file)) continue;
                allowedLines.add(Objects.requireNonNull(pathInclude.line()));
            }
            HashSet<Integer> disallowedLines = new HashSet<Integer>();
            for (PathMatcher pathExclude : this.pathExcludes) {
                if (!pathExclude.targetsLine() || !pathExclude.matches(file)) continue;
                disallowedLines.add(Objects.requireNonNull(pathExclude.line()));
            }
            if (!allowedLines.isEmpty() && !disallowedLines.isEmpty()) {
                throw new IllegalArgumentException("can't have both include and exclude targetining individual lines for a file");
            }
            if (allowedLines.isEmpty() && disallowedLines.isEmpty()) {
                return new LineIncludesExcludes.MatchesEverything();
            }
            if (!allowedLines.isEmpty()) {
                return LineIncludesExcludes.fromIncludedLines(allowedLines);
            }
            return LineIncludesExcludes.fromExcludedLines(disallowedLines);
        }

        public String toString() {
            return "Includes: " + this.pathIncludes + "\nExcludes: " + this.pathExcludes;
        }
    }
}

