/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.google.common.annotations.VisibleForTesting;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodReporterStrategy;
import io.codemodder.DependencyGAV;
import io.codemodder.FixOnlyCodeChanger;
import io.codemodder.RegionNodeMatcher;
import io.codemodder.RuleSarif;
import io.codemodder.SarifFindingKeyUtil;
import io.codemodder.SourceCodeRegion;
import io.codemodder.SourceCodeRegionExtractor;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.javaparser.ChangesResult;
import io.codemodder.javaparser.JavaParserChanger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class SarifPluginJavaParserChanger<T extends Node>
extends JavaParserChanger {
    @VisibleForTesting
    public final RuleSarif sarif;
    private final Class<? extends Node> nodeType;
    private final SourceCodeRegionExtractor<Result> regionExtractor;
    private final RegionNodeMatcher regionNodeMatcher;

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType) {
        this(sarif, nodeType, SourceCodeRegionExtractor.FROM_SARIF_FIRST_LOCATION, RegionNodeMatcher.EXACT_MATCH);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, SourceCodeRegionExtractor<Result> regionExtractor) {
        this(sarif, nodeType, regionExtractor, RegionNodeMatcher.EXACT_MATCH);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, CodemodReporterStrategy codemodReporterStrategy) {
        this(sarif, nodeType, RegionNodeMatcher.EXACT_MATCH, codemodReporterStrategy);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, RegionNodeMatcher regionNodeMatcher) {
        this(sarif, nodeType, SourceCodeRegionExtractor.FROM_SARIF_FIRST_LOCATION, regionNodeMatcher);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, RegionNodeMatcher regionNodeMatcher, CodemodReporterStrategy reporterStrategy) {
        this(sarif, nodeType, SourceCodeRegionExtractor.FROM_SARIF_FIRST_LOCATION, regionNodeMatcher, reporterStrategy);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, SourceCodeRegionExtractor<Result> regionExtractor, RegionNodeMatcher regionNodeMatcher) {
        this.sarif = Objects.requireNonNull(sarif);
        this.nodeType = Objects.requireNonNull(nodeType);
        this.regionExtractor = Objects.requireNonNull(regionExtractor);
        this.regionNodeMatcher = Objects.requireNonNull(regionNodeMatcher);
    }

    protected SarifPluginJavaParserChanger(RuleSarif sarif, Class<? extends Node> nodeType, SourceCodeRegionExtractor<Result> regionExtractor, RegionNodeMatcher regionNodeMatcher, CodemodReporterStrategy reporter) {
        super(reporter);
        this.sarif = Objects.requireNonNull(sarif);
        this.nodeType = Objects.requireNonNull(nodeType);
        this.regionExtractor = Objects.requireNonNull(regionExtractor);
        this.regionNodeMatcher = Objects.requireNonNull(regionNodeMatcher);
    }

    @Override
    public CodemodFileScanningResult visit(CodemodInvocationContext context, CompilationUnit cu) {
        List<Result> results = this.sarif.getResultsByLocationPath(context.path());
        if (results.isEmpty()) {
            return CodemodFileScanningResult.none();
        }
        List allNodes = cu.findAll(this.nodeType);
        ArrayList<CodemodChange> codemodChanges = new ArrayList<CodemodChange>();
        for (Result result : results) {
            for (Node node : allNodes) {
                ChangesResult changeSuccessful;
                Range range;
                SourceCodeRegion region = this.regionExtractor.from(result);
                if (!this.nodeType.isAssignableFrom(node.getClass()) || !context.lineIncludesExcludes().matches(region.start().line()) || !node.getRange().isPresent() || !this.regionNodeMatcher.matches(region, range = (Range)node.getRange().get()) || !(changeSuccessful = this.onResultFound(context, cu, node, result)).areChangesApplied()) continue;
                codemodChanges.add(this.buildCodemodChange(context.path(), region.start().line(), changeSuccessful.getDependenciesRequired(), result));
            }
        }
        return CodemodFileScanningResult.withOnlyChanges(codemodChanges);
    }

    private CodemodChange buildCodemodChange(Path path, int line, List<DependencyGAV> dependencies, Result result) {
        SarifPluginJavaParserChanger sarifPluginJavaParserChanger = this;
        if (sarifPluginJavaParserChanger instanceof FixOnlyCodeChanger) {
            FixOnlyCodeChanger fixOnlyCodeChanger = (FixOnlyCodeChanger)((Object)sarifPluginJavaParserChanger);
            return CodemodChange.from(line, dependencies, new FixedFinding(SarifFindingKeyUtil.buildFindingId(result, path, line), fixOnlyCodeChanger.detectorRule()));
        }
        return CodemodChange.from(line, dependencies);
    }

    @Override
    public boolean shouldRun() {
        List runs = this.sarif.rawDocument().getRuns();
        return runs != null && runs.size() > 0 && !((Run)runs.get(0)).getResults().isEmpty();
    }

    public abstract ChangesResult onResultFound(CodemodInvocationContext var1, CompilationUnit var2, T var3, Result var4);
}

