/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public interface XPathStreamProcessChange {
    public Set<Integer> linesAffected();

    public Path transformedXml();

    public static class Default
    implements XPathStreamProcessChange {
        private final Set<Integer> linesAffected;
        private final Path transformedXml;

        public Default(Set<Integer> linesAffected, Path transformedXml) {
            this.linesAffected = Objects.requireNonNull(linesAffected);
            this.transformedXml = Objects.requireNonNull(transformedXml);
        }

        @Override
        public Set<Integer> linesAffected() {
            return Collections.unmodifiableSet(this.linesAffected);
        }

        @Override
        public Path transformedXml() {
            return this.transformedXml;
        }
    }
}

