/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.jndiinjection;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import io.codemodder.DependencyGAV;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.remediation.jndiinjection.JNDIFixStrategy;
import java.util.List;
import java.util.Set;

final class InjectValidationMethodStrategy
implements JNDIFixStrategy {
    private final MethodDeclaration fixMethod;
    private static final String validateResourceMethodName = "validateResourceName";

    InjectValidationMethodStrategy() {
        String fixMethodCode = "private static void validateResourceName(final String name) {\n    if (name != null) {\n      Set<String> illegalNames = Set.of(\"ldap://\", \"rmi://\", \"dns://\", \"java:\");\n      String canonicalName = name.toLowerCase().trim();\n      if (illegalNames.stream().anyMatch(canonicalName::startsWith)) {\n        throw new SecurityException(\"Illegal JNDI resource name: \" + name);\n      }\n    }\n}\n";
        this.fixMethod = StaticJavaParser.parseMethodDeclaration((String)fixMethodCode);
    }

    @Override
    public List<DependencyGAV> fix(CompilationUnit cu, ClassOrInterfaceDeclaration parentClass, MethodCallExpr lookupCall, NameExpr contextNameVariable, BlockStmt blockStmt, int index) {
        MethodCallExpr validationCall = new MethodCallExpr(null, validateResourceMethodName);
        validationCall.addArgument((Expression)contextNameVariable);
        blockStmt.addStatement(index, (Expression)validationCall);
        boolean alreadyHasResourceValidationCallPresent = parentClass.findAll(MethodDeclaration.class).stream().anyMatch(md -> md.getNameAsString().equals(validateResourceMethodName) && md.getParameters().size() == 1 && ((Parameter)md.getParameters().get(0)).getTypeAsString().equals("String"));
        if (!alreadyHasResourceValidationCallPresent) {
            parentClass.addMember((BodyDeclaration)this.fixMethod);
            ASTTransforms.addImportIfMissing(cu, Set.class);
        }
        return List.of();
    }
}

