/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.sqlinjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.FixCandidate;
import io.codemodder.remediation.FixCandidateSearchResults;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.sqlinjection.JavaParserSQLInjectionRemediatorStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.javatuples.Pair;

final class DefaultJavaParserSQLInjectionRemediatorStrategy
implements JavaParserSQLInjectionRemediatorStrategy {
    private Map<Predicate<MethodCallExpr>, Predicate<MethodCallExpr>> remediationStrategies;

    DefaultJavaParserSQLInjectionRemediatorStrategy(Predicate<MethodCallExpr> matcher, Predicate<MethodCallExpr> fixer) {
        this.remediationStrategies = Map.of(matcher, fixer);
    }

    DefaultJavaParserSQLInjectionRemediatorStrategy(Map<Predicate<MethodCallExpr>, Predicate<MethodCallExpr>> strategies) {
        this.remediationStrategies = strategies;
    }

    private <T> Pair<List<CodemodChange>, List<UnfixedFinding>> remediateWithStrategy(CompilationUnit cu, String path, DetectorRule detectorRule, Collection<T> findingsForPath, Function<T, String> findingIdExtractor, Function<T, Integer> findingLineExtractor, Predicate<MethodCallExpr> matcher, Predicate<MethodCallExpr> fixer) {
        FixCandidateSearcher<Object> searcher = new FixCandidateSearcher.Builder().withMatcher(matcher).build();
        FixCandidateSearchResults<Object> results = searcher.search(cu, path, detectorRule, new ArrayList<T>(findingsForPath), findingIdExtractor, findingLineExtractor, f -> null);
        if (findingsForPath.isEmpty()) {
            return Pair.with(List.of(), List.of());
        }
        ArrayList unfixedFindings = new ArrayList();
        ArrayList changes = new ArrayList();
        for (FixCandidate<Object> fixCandidate : results.fixCandidates()) {
            List<Object> issues = fixCandidate.issues();
            Integer line = findingLineExtractor.apply(issues.get(0));
            if (line == null) {
                issues.forEach(issue -> {
                    String id = (String)findingIdExtractor.apply(issue);
                    UnfixedFinding unfixableFinding = new UnfixedFinding(id, detectorRule, path, null, "No line number provided");
                    unfixedFindings.add(unfixableFinding);
                });
                continue;
            }
            MethodCallExpr methodCallExpr = fixCandidate.methodCall();
            if (fixer.test(methodCallExpr)) {
                issues.forEach(issue -> {
                    String id = (String)findingIdExtractor.apply(issue);
                    changes.add(CodemodChange.from((int)line, new FixedFinding(id, detectorRule)));
                });
                continue;
            }
            issues.forEach(issue -> {
                String id = (String)findingIdExtractor.apply(issue);
                UnfixedFinding unfixableFinding = new UnfixedFinding(id, detectorRule, path, line, "State changing effects possible or unrecognized code shape");
                unfixedFindings.add(unfixableFinding);
            });
        }
        return Pair.with(changes, unfixedFindings);
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, Collection<T> findingsForPath, Function<T, String> findingIdExtractor, Function<T, Integer> findingLineExtractor) {
        ArrayList<CodemodChange> allChanges = new ArrayList<CodemodChange>();
        ArrayList<UnfixedFinding> allUnfixed = new ArrayList<UnfixedFinding>();
        for (Predicate<MethodCallExpr> matcher : this.remediationStrategies.keySet()) {
            Predicate<MethodCallExpr> fixer = this.remediationStrategies.get(matcher);
            Pair<List<CodemodChange>, List<UnfixedFinding>> pairResult = this.remediateWithStrategy(cu, path, detectorRule, findingsForPath, findingIdExtractor, findingLineExtractor, matcher, fixer);
            allChanges.addAll((Collection)pairResult.getValue0());
            allUnfixed.addAll((Collection)pairResult.getValue1());
        }
        return CodemodFileScanningResult.from(allChanges, allUnfixed);
    }
}

