/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.xxe.DocumentBuilderFactoryAndSAXParserAtCreationFixer;
import io.codemodder.remediation.xxe.DocumentBuilderFactoryAtParseFixer;
import io.codemodder.remediation.xxe.TransformerFactoryAtCreationFixer;
import io.codemodder.remediation.xxe.XMLReaderAtParseFixer;
import io.codemodder.remediation.xxe.XXEFixAttempt;
import io.codemodder.remediation.xxe.XXEFixer;
import io.codemodder.remediation.xxe.XXERemediator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

final class DefaultXXERemediator
implements XXERemediator {
    private final List<XXEFixer> fixers = List.of(new DocumentBuilderFactoryAndSAXParserAtCreationFixer(), new DocumentBuilderFactoryAtParseFixer(), new TransformerFactoryAtCreationFixer(), new XMLReaderAtParseFixer());

    DefaultXXERemediator() {
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        for (T issue : issuesForFile) {
            String findingId = getKey.apply(issue);
            int line = getLine.apply(issue);
            Integer column = getColumn.apply(issue);
            for (XXEFixer fixer : this.fixers) {
                XXEFixAttempt fixAttempt = fixer.tryFix(line, column, cu);
                if (!fixAttempt.isResponsibleFixer()) continue;
                if (fixAttempt.isFixed()) {
                    CodemodChange change = CodemodChange.from(line, new FixedFinding(findingId, detectorRule));
                    changes.add(change);
                    continue;
                }
                UnfixedFinding unfixedFinding = new UnfixedFinding(findingId, detectorRule, path, Integer.valueOf(line), fixAttempt.reasonNotFixed());
                unfixedFindings.add(unfixedFinding);
            }
        }
        return CodemodFileScanningResult.from(changes, unfixedFindings);
    }
}

