/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.javaparser.ASTExpectations;
import io.codemodder.remediation.xxe.XMLFeatures;
import io.codemodder.remediation.xxe.XXEFixAttempt;
import io.codemodder.remediation.xxe.XXEFixer;
import java.util.List;
import java.util.Optional;

final class DocumentBuilderFactoryAndSAXParserAtCreationFixer
implements XXEFixer {
    DocumentBuilderFactoryAndSAXParserAtCreationFixer() {
    }

    @Override
    public XXEFixAttempt tryFix(int line, Integer column, CompilationUnit cu) {
        List<MethodCallExpr> candidateMethods = ASTs.findMethodCallsWhichAreAssignedToType(cu, line, column, "newInstance", List.of("DocumentBuilderFactory", "SAXParserFactory"));
        if (candidateMethods.isEmpty()) {
            return new XXEFixAttempt(false, false, "No calls at that location");
        }
        if (candidateMethods.size() > 1) {
            return new XXEFixAttempt(false, false, "Multiple calls found at the given location and that may cause confusion");
        }
        MethodCallExpr newFactoryInstanceCall = candidateMethods.get(0);
        Optional<VariableDeclarator> newFactoryVariableRef = ASTExpectations.expect((Node)newFactoryInstanceCall).toBeMethodCallExpression().initializingVariable().result();
        VariableDeclarator newFactoryVariable = newFactoryVariableRef.get();
        Optional variableDeclarationStmtRef = newFactoryVariable.findAncestor(new Class[]{Statement.class});
        if (variableDeclarationStmtRef.isEmpty()) {
            return new XXEFixAttempt(true, false, "Not assigned as part of statement");
        }
        Statement statement = (Statement)variableDeclarationStmtRef.get();
        return XMLFeatures.addFeatureDisablingStatements(newFactoryVariable.getNameAsExpression(), statement, false);
    }
}

