/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface FileCache {
    public String get(Path var1) throws IOException;

    public void overrideEntry(Path var1, String var2);

    public void removeEntry(Path var1);

    public static FileCache createDefault() {
        return FileCache.createDefault(10000);
    }

    public static FileCache createDefault(final int maxSize) {
        return new FileCache(){
            private final Map<Path, String> fileCache = new ConcurrentHashMap<Path, String>();

            @Override
            public String get(Path path) throws IOException {
                String contents = this.fileCache.get(path);
                if (contents == null) {
                    contents = Files.readString(path);
                    if (this.fileCache.size() < maxSize) {
                        this.fileCache.put(path, contents);
                    }
                }
                return contents;
            }

            @Override
            public void overrideEntry(Path path, String contents) {
                if (!this.fileCache.containsKey(path)) {
                    throw new IllegalArgumentException("cache entry must be for an existing key");
                }
                this.fileCache.put(path, contents);
            }

            @Override
            public void removeEntry(Path path) {
                this.fileCache.remove(path);
            }
        };
    }
}

