/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalScope;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface LocalDeclaration {
    public String getName();

    public Node getDeclaration();

    public LocalScope getScope();

    default public boolean isReference(NameExpr reference) {
        return reference.getNameAsString().equals(this.getName()) && ASTs.findNonCallableSimpleNameSource(reference.getName()).filter(m -> m == this.getDeclaration()).isPresent();
    }

    default public Stream<NameExpr> findAllReferences() {
        return this.getScope().stream().flatMap(n -> n.findAll(NameExpr.class).stream()).filter(this::isReference);
    }

    default public Stream<MethodCallExpr> findAllMethodCalls() {
        Predicate<MethodCallExpr> isScopeInMethodCall = mce -> mce.getScope().filter(s -> s.isNameExpr() && this.isReference(s.asNameExpr())).isPresent();
        return this.getScope().stream().flatMap(n -> n.findAll(MethodCallExpr.class, isScopeInMethodCall).stream());
    }
}

