/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.FixCandidate;
import io.codemodder.remediation.FixCandidateSearchResults;
import io.codemodder.remediation.FixCandidateSearcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.VisibleForTesting;

final class DefaultFixCandidateSearcher<T>
implements FixCandidateSearcher<T> {
    private final List<Predicate<Node>> matchers;

    DefaultFixCandidateSearcher(List<Predicate<Node>> matchers) {
        this.matchers = matchers;
    }

    @Override
    public FixCandidateSearchResults<T> search(CompilationUnit cu, String path, DetectorRule rule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getStartLine, Function<T, Optional<Integer>> getEndLine, Function<T, Optional<Integer>> getColumn) {
        final ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        List<Node> nodes = cu.findAll(Node.class).stream().filter(n -> this.matchers.stream().allMatch(m -> m.test(n))).toList();
        HashMap<Node, List> fixCandidateToIssueMapping = new HashMap<Node, List>();
        for (T issue : issuesForFile) {
            String findingId = getKey.apply(issue);
            int issueStartLine = getStartLine.apply(issue);
            Optional<Integer> maybeEndLine = getEndLine.apply(issue);
            Optional<Integer> maybeColumn = getColumn.apply(issue);
            List<Node> nodesForIssue = nodes.stream().filter(n -> {
                int nodeStartLine = ((Range)n.getRange().orElseThrow()).begin.line;
                return maybeEndLine.map(issueEndLine -> DefaultFixCandidateSearcher.matches(issueStartLine, nodeStartLine, issueEndLine)).orElse(DefaultFixCandidateSearcher.matches(issueStartLine, nodeStartLine));
            }).filter(n -> maybeColumn.map(column -> ((Range)n.getRange().orElseThrow()).contains(new Position(issueStartLine, column.intValue()))).orElse(true)).toList();
            if (nodesForIssue.isEmpty()) {
                unfixedFindings.add(new UnfixedFinding(findingId, rule, path, Integer.valueOf(issueStartLine), "No nodes at that location"));
                continue;
            }
            if (nodesForIssue.size() > 1) {
                unfixedFindings.add(new UnfixedFinding(findingId, rule, path, Integer.valueOf(issueStartLine), "Multiple nodes found at the given location and that may cause confusion"));
                continue;
            }
            Node node = nodesForIssue.get(0);
            fixCandidateToIssueMapping.computeIfAbsent(node, k -> new ArrayList()).add(issue);
        }
        final List<FixCandidate> fixCandidates = fixCandidateToIssueMapping.entrySet().stream().map(entry -> new FixCandidate((Node)entry.getKey(), (List)entry.getValue())).toList();
        return new FixCandidateSearchResults<T>(){

            @Override
            public List<UnfixedFinding> unfixableFindings() {
                return unfixedFindings;
            }

            @Override
            public List<FixCandidate<T>> fixCandidates() {
                return fixCandidates;
            }
        };
    }

    @VisibleForTesting
    static boolean matches(int issueStartLine, int startNodeLine, int issueEndLine) {
        return DefaultFixCandidateSearcher.matches(issueStartLine, startNodeLine) && DefaultFixCandidateSearcher.isInBetween(startNodeLine, issueStartLine, issueEndLine);
    }

    static boolean matches(int issueStartLine, int startNodeLine) {
        return startNodeLine == issueStartLine;
    }

    private static boolean isInBetween(int number, int lowerBound, int upperBound) {
        return number >= lowerBound && number <= upperBound;
    }
}

