/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation;

import com.github.javaparser.Position;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.LegacyFixCandidate;
import io.codemodder.remediation.LegacyFixCandidateSearchResults;
import io.codemodder.remediation.LegacyFixCandidateSearcher;
import io.codemodder.remediation.MethodOrConstructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.VisibleForTesting;

@Deprecated
final class DefaultLegacyFixCandidateSearcher<T>
implements LegacyFixCandidateSearcher<T> {
    private final List<Predicate<MethodOrConstructor>> matchers;
    private final String methodName;

    DefaultLegacyFixCandidateSearcher(String methodName, List<Predicate<MethodOrConstructor>> matchers) {
        this.methodName = methodName;
        this.matchers = matchers;
    }

    @Override
    public LegacyFixCandidateSearchResults<T> search(CompilationUnit cu, String path, DetectorRule rule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getStartLine, Function<T, Integer> getEndLine, Function<T, Integer> getColumn) {
        final ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        List<MethodOrConstructor> calls = cu.findAll(Node.class).stream().filter(n -> n instanceof MethodCallExpr || n instanceof ObjectCreationExpr).map(MethodOrConstructor::new).filter(MethodOrConstructor::hasRange).filter(mce -> this.methodName == null || mce.isMethodCallWithName(this.methodName)).filter(mce -> this.matchers.stream().allMatch(m -> m.test(mce))).toList();
        HashMap<MethodOrConstructor, List> fixCandidateToIssueMapping = new HashMap<MethodOrConstructor, List>();
        for (T issue : issuesForFile) {
            String findingId = getKey.apply(issue);
            int issueStartLine = getStartLine.apply(issue);
            Integer issueEndLine = getEndLine.apply(issue);
            Integer column = getColumn.apply(issue);
            List<MethodOrConstructor> callsForIssue = calls.stream().filter(MethodOrConstructor::hasRange).filter(mce -> {
                int callStartLine = mce.getRange().begin.line;
                return DefaultLegacyFixCandidateSearcher.matches(issueStartLine, issueEndLine, callStartLine);
            }).toList();
            if (callsForIssue.size() > 1 && column != null) {
                callsForIssue = callsForIssue.stream().filter(mce -> mce.getRange().contains(new Position(issueStartLine, column.intValue()))).toList();
            }
            if (callsForIssue.isEmpty()) {
                unfixedFindings.add(new UnfixedFinding(findingId, rule, path, Integer.valueOf(issueStartLine), "No nodes at that location"));
                continue;
            }
            if (callsForIssue.size() > 1) {
                unfixedFindings.add(new UnfixedFinding(findingId, rule, path, Integer.valueOf(issueStartLine), "Multiple nodes found at the given location and that may cause confusion"));
                continue;
            }
            MethodOrConstructor call = callsForIssue.get(0);
            fixCandidateToIssueMapping.computeIfAbsent(call, k -> new ArrayList()).add(issue);
        }
        final List<LegacyFixCandidate> legacyFixCandidates = fixCandidateToIssueMapping.entrySet().stream().map(entry -> new LegacyFixCandidate((MethodOrConstructor)entry.getKey(), (List)entry.getValue())).toList();
        return new LegacyFixCandidateSearchResults<T>(){

            @Override
            public List<UnfixedFinding> unfixableFindings() {
                return unfixedFindings;
            }

            @Override
            public List<LegacyFixCandidate<T>> fixCandidates() {
                return legacyFixCandidates;
            }
        };
    }

    @VisibleForTesting
    static boolean matches(int issueStartLine, Integer issueEndLine, int startCallLine) {
        if (issueEndLine != null) {
            return DefaultLegacyFixCandidateSearcher.isInBetween(startCallLine, issueStartLine, issueEndLine);
        }
        return startCallLine == issueStartLine;
    }

    private static boolean isInBetween(int number, int lowerBound, int upperBound) {
        return number >= lowerBound && number <= upperBound;
    }
}

