/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.FixCandidate;
import io.codemodder.remediation.FixCandidateSearchResults;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.ModularRemediationStrategy;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.Remediator;
import io.codemodder.remediation.SuccessOrReason;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.javatuples.Pair;

public class SearcherStrategyRemediator<T>
implements Remediator<T> {
    private final Map<FixCandidateSearcher<T>, RemediationStrategy> searcherRemediatorMap;

    protected SearcherStrategyRemediator(Map<FixCandidateSearcher<T>, RemediationStrategy> searcherRemediatorMap) {
        this.searcherRemediatorMap = searcherRemediatorMap;
    }

    private Pair<List<CodemodChange>, List<UnfixedFinding>> remediateWithStrategy(CompilationUnit cu, String path, DetectorRule detectorRule, Collection<T> findingsForPath, Function<T, String> findingIdExtractor, Function<T, Integer> findingStartLineExtractor, Function<T, Optional<Integer>> findingEndLineExtractor, Function<T, Optional<Integer>> findingColumnExtractor, FixCandidateSearcher<T> searcher, RemediationStrategy strategy) {
        FixCandidateSearchResults<T> results = searcher.search(cu, path, detectorRule, new ArrayList<T>(findingsForPath), findingIdExtractor, findingStartLineExtractor, findingEndLineExtractor, findingColumnExtractor);
        if (findingsForPath.isEmpty()) {
            return Pair.with(List.of(), List.of());
        }
        ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>(results.unfixableFindings());
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        for (FixCandidate<T> fixCandidate : results.fixCandidates()) {
            List<Object> issues = fixCandidate.issues();
            Integer line = findingStartLineExtractor.apply(issues.get(0));
            if (line == null) {
                issues.forEach(issue -> {
                    String id = (String)findingIdExtractor.apply(issue);
                    UnfixedFinding unfixableFinding = new UnfixedFinding(id, detectorRule, path, null, "No line number provided");
                    unfixedFindings.add(unfixableFinding);
                });
                continue;
            }
            SuccessOrReason maybeDeps = strategy.fix(cu, fixCandidate.node());
            if (maybeDeps.isSuccess()) {
                List<FixedFinding> fixedFindings = issues.stream().map(findingIdExtractor).map(findingId -> new FixedFinding(findingId, detectorRule)).toList();
                changes.add(CodemodChange.from((int)line, maybeDeps.getDependencies(), fixedFindings));
                continue;
            }
            issues.forEach(issue -> {
                String id = (String)findingIdExtractor.apply(issue);
                UnfixedFinding unfixableFinding = new UnfixedFinding(id, detectorRule, path, line, maybeDeps.getReason());
                unfixedFindings.add(unfixableFinding);
            });
        }
        return Pair.with(changes, unfixedFindings);
    }

    @Override
    public CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, Collection<T> findingsForPath, Function<T, String> findingIdExtractor, Function<T, Integer> findingStartLineExtractor, Function<T, Optional<Integer>> findingEndLineExtractor, Function<T, Optional<Integer>> findingColumnExtractor) {
        ArrayList<CodemodChange> allChanges = new ArrayList<CodemodChange>();
        ArrayList<UnfixedFinding> allUnfixed = new ArrayList<UnfixedFinding>();
        for (Map.Entry<FixCandidateSearcher<T>, RemediationStrategy> searcherAndStrategy : this.searcherRemediatorMap.entrySet()) {
            Pair<List<CodemodChange>, List<UnfixedFinding>> pairResult = this.remediateWithStrategy(cu, path, detectorRule, findingsForPath, findingIdExtractor, findingStartLineExtractor, findingEndLineExtractor, findingColumnExtractor, searcherAndStrategy.getKey(), searcherAndStrategy.getValue());
            allChanges.addAll((Collection)pairResult.getValue0());
            allUnfixed.addAll((Collection)pairResult.getValue1());
        }
        return CodemodFileScanningResult.from(allChanges, allUnfixed);
    }

    public static final class Builder<T> {
        private final Map<FixCandidateSearcher<T>, RemediationStrategy> searcherRemediatorMap = new HashMap<FixCandidateSearcher<T>, RemediationStrategy>();

        public Builder<T> withSearcherStrategyPair(FixCandidateSearcher<T> searcher, RemediationStrategy strategy) {
            this.searcherRemediatorMap.put(Objects.requireNonNull(searcher), Objects.requireNonNull(strategy));
            return this;
        }

        public Builder<T> withFunctions(Predicate<Node> searcherMatcher, BiFunction<CompilationUnit, Node, SuccessOrReason> fixer) {
            this.searcherRemediatorMap.put(new FixCandidateSearcher.Builder().withMatcher(Objects.requireNonNull(searcherMatcher)).build(), new ModularRemediationStrategy(fixer));
            return this;
        }

        public SearcherStrategyRemediator<T> build() {
            return new SearcherStrategyRemediator<T>(this.searcherRemediatorMap);
        }
    }
}

