/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.headerinjection;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.LegacyFixCandidate;
import io.codemodder.remediation.LegacyFixCandidateSearchResults;
import io.codemodder.remediation.LegacyFixCandidateSearcher;
import io.codemodder.remediation.MethodOrConstructor;
import io.codemodder.remediation.headerinjection.HeaderInjectionRemediator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

final class DefaultHeaderInjectionRemediator
implements HeaderInjectionRemediator {
    private static final Set<String> setHeaderNames = Set.of("setHeader", "addHeader");
    private static final String validatorMethodName = "stripNewlines";
    private final String fixMethodCode;

    DefaultHeaderInjectionRemediator() {
        this.fixMethodCode = "private static String stripNewlines(final String s) {\n  return s.replaceAll(\"[\\n\\r]\", \"\");\n}\n";
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getStartLine, Function<T, Integer> getEndLine, Function<T, Integer> getStartColumn) {
        LegacyFixCandidateSearcher<T> searcher = new LegacyFixCandidateSearcher.Builder().withMatcher(mce -> mce.isMethodCallWithNameIn(setHeaderNames)).withMatcher(MethodOrConstructor::isMethodCallWithScope).withMatcher(mce -> mce.getArguments().size() == 2).withMatcher(mce -> !(mce.getArguments().get(1) instanceof StringLiteralExpr)).build();
        LegacyFixCandidateSearchResults results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getStartLine, getEndLine, getStartColumn);
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        for (LegacyFixCandidate legacyFixCandidate : results.fixCandidates()) {
            List issues = legacyFixCandidate.issues();
            MethodCallExpr setHeaderCall = legacyFixCandidate.call().asMethodCall();
            Expression headerValueArgument = setHeaderCall.getArgument(1);
            JavaParserTransformer.wrap(headerValueArgument).withScopelessMethod(validatorMethodName);
            ClassOrInterfaceDeclaration parentClass = (ClassOrInterfaceDeclaration)setHeaderCall.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).get();
            if (parentClass.isInterface()) {
                MethodCallExpr inlinedStripCall = new MethodCallExpr(headerValueArgument, "replaceAll", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr("[\\n\\r]"), new StringLiteralExpr("")}));
                setHeaderCall.getArguments().set(1, (Node)inlinedStripCall);
            } else {
                boolean alreadyHasResourceValidationCallPresent = parentClass.findAll(MethodDeclaration.class).stream().anyMatch(md -> md.getNameAsString().equals(validatorMethodName) && md.getParameters().size() == 1 && ((Parameter)md.getParameters().get(0)).getTypeAsString().equals("String"));
                if (!alreadyHasResourceValidationCallPresent) {
                    MethodDeclaration fixMethod = StaticJavaParser.parseMethodDeclaration((String)this.fixMethodCode);
                    parentClass.addMember((BodyDeclaration)fixMethod);
                }
            }
            int line = getStartLine.apply(legacyFixCandidate.issues().get(0));
            List<FixedFinding> fixedFindings = issues.stream().map(issue -> new FixedFinding((String)getKey.apply(issue), detectorRule)).toList();
            changes.add(CodemodChange.from(line, List.of(), fixedFindings));
        }
        return CodemodFileScanningResult.from(changes, results.unfixableFindings());
    }
}

