/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.javadeserialization;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.DependencyGAV;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalDeclaration;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.LegacyFixCandidate;
import io.codemodder.remediation.LegacyFixCandidateSearchResults;
import io.codemodder.remediation.LegacyFixCandidateSearcher;
import io.codemodder.remediation.MethodOrConstructor;
import io.codemodder.remediation.javadeserialization.JavaDeserializationRemediator;
import io.github.pixee.security.ObjectInputFilters;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class DefaultJavaDeserializationRemediator
implements JavaDeserializationRemediator {
    DefaultJavaDeserializationRemediator() {
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getStartLine, Function<T, Integer> getEndLine, Function<T, Integer> getStartColumn) {
        LegacyFixCandidateSearcher<T> searcher = new LegacyFixCandidateSearcher.Builder().withMethodName("readObject").withMatcher(MethodOrConstructor::isMethodCallWithScope).withMatcher(mce -> mce.getArguments().isEmpty()).build();
        LegacyFixCandidateSearchResults results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getStartLine, getEndLine, getStartColumn);
        if (results.fixCandidates().isEmpty()) {
            searcher = new LegacyFixCandidateSearcher.Builder().withMatcher(mc -> mc.isConstructorForType("ObjectInputStream")).build();
            results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getStartLine, getEndLine, getStartColumn);
        }
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        for (LegacyFixCandidate legacyFixCandidate : results.fixCandidates()) {
            List issues = legacyFixCandidate.issues();
            MethodOrConstructor call = legacyFixCandidate.call();
            if (call.isConstructor()) {
                this.fixObjectInputStreamCreation((ObjectCreationExpr)call.asNode());
                CodemodChange change = DefaultJavaDeserializationRemediator.buildFixChange(detectorRule, getKey, getStartLine, issues);
                changes.add(change);
                continue;
            }
            MethodCallExpr mce2 = (MethodCallExpr)call.asNode();
            Expression callScope = (Expression)mce2.getScope().get();
            if (!callScope.isNameExpr()) {
                issues.stream().map(i -> new UnfixedFinding((String)getKey.apply(i), detectorRule, path, (Integer)getStartLine.apply(i), "Unexpected shape")).forEach(unfixedFindings::add);
                continue;
            }
            Optional<LocalDeclaration> declaration = ASTs.findEarliestLocalDeclarationOf(callScope.asNameExpr().getName());
            if (declaration.isEmpty()) {
                issues.stream().map(i -> new UnfixedFinding((String)getKey.apply(i), detectorRule, path, (Integer)getStartLine.apply(i), "No declaration found")).forEach(unfixedFindings::add);
                continue;
            }
            LocalDeclaration localDeclaration = declaration.get();
            Node varDeclarationAndExpr = localDeclaration.getDeclaration();
            if (varDeclarationAndExpr instanceof VariableDeclarator) {
                VariableDeclarator varDec = (VariableDeclarator)varDeclarationAndExpr;
                Optional initializer = varDec.getInitializer();
                if (initializer.isEmpty()) {
                    issues.stream().map(i -> new UnfixedFinding((String)getKey.apply(i), detectorRule, path, (Integer)getStartLine.apply(i), "No initializer found")).forEach(unfixedFindings::add);
                    continue;
                }
                Expression expression = (Expression)initializer.get();
                if (!(expression instanceof ObjectCreationExpr)) continue;
                ObjectCreationExpr objCreation = (ObjectCreationExpr)expression;
                this.fixObjectInputStreamCreation(objCreation);
                CodemodChange change = DefaultJavaDeserializationRemediator.buildFixChange(detectorRule, getKey, getStartLine, issues);
                changes.add(change);
                continue;
            }
            issues.stream().map(i -> new UnfixedFinding((String)getKey.apply(i), detectorRule, path, (Integer)getStartLine.apply(i), "Unexpected declaration type")).forEach(unfixedFindings::add);
        }
        unfixedFindings.addAll(results.unfixableFindings());
        return CodemodFileScanningResult.from(changes, unfixedFindings);
    }

    @NotNull
    private static <T> CodemodChange buildFixChange(DetectorRule detectorRule, Function<T, String> getKey, Function<T, Integer> getLine, List<T> issues) {
        return CodemodChange.from((int)getLine.apply(issues.get(0)), List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT), issues.stream().map(i -> new FixedFinding((String)getKey.apply(i), detectorRule)).toList());
    }

    private void fixObjectInputStreamCreation(ObjectCreationExpr objCreation) {
        JavaParserTransformer.replace((Expression)objCreation).withStaticMethod(ObjectInputFilters.class.getName(), "createSafeObjectInputStream").withStaticImport().withSameArguments();
    }
}

