/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.missingsecureflag;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.LegacyFixCandidate;
import io.codemodder.remediation.LegacyFixCandidateSearchResults;
import io.codemodder.remediation.LegacyFixCandidateSearcher;
import io.codemodder.remediation.missingsecureflag.MissingSecureFlagRemediator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class DefaultMissingSecureFlagRemediator
implements MissingSecureFlagRemediator {
    DefaultMissingSecureFlagRemediator() {
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getStartLine, Function<T, Integer> getEndLine, Function<T, Integer> getStartColumn) {
        LegacyFixCandidateSearcher<T> searcher = new LegacyFixCandidateSearcher.Builder().withMethodName("addCookie").withMatcher(mce -> mce.getArguments().size() == 1).build();
        LegacyFixCandidateSearchResults results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getStartLine, getEndLine, getStartColumn);
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        for (LegacyFixCandidate result : results.fixCandidates()) {
            MethodCallExpr methodCallExpr = result.call().asMethodCall();
            List issues = result.issues();
            if (methodCallExpr.getScope().isPresent()) {
                Optional<Statement> maybeStmt = methodCallExpr.getParentNode().map(p -> p instanceof Statement ? (Statement)p : null).filter(Statement::isExpressionStmt);
                Optional<Expression> maybeCookieExpression = Optional.of(methodCallExpr.getArgument(0)).filter(expr -> expr.isNameExpr() || expr.isFieldAccessExpr());
                if (maybeStmt.isPresent() && maybeCookieExpression.isPresent()) {
                    ExpressionStmt newStatement = new ExpressionStmt((Expression)new MethodCallExpr(maybeCookieExpression.get(), "setSecure", new NodeList((Node[])new Expression[]{new BooleanLiteralExpr(true)})));
                    ASTTransforms.addStatementBeforeStatement(maybeStmt.get(), (Statement)newStatement);
                    FixedFinding fixedFinding = new FixedFinding(getKey.apply(issues.get(0)), detectorRule);
                    CodemodChange change = CodemodChange.from(result.call().getRange().begin.line, List.of(), List.of(fixedFinding));
                    changes.add(change);
                    continue;
                }
                List<UnfixedFinding> unfixedFindingsToAdd = DefaultMissingSecureFlagRemediator.createUnfixedFindingList(path, detectorRule, getKey, getStartLine, issues);
                unfixedFindings.addAll(unfixedFindingsToAdd);
                continue;
            }
            List<UnfixedFinding> unfixedFindingsToAdd = DefaultMissingSecureFlagRemediator.createUnfixedFindingList(path, detectorRule, getKey, getStartLine, issues);
            unfixedFindings.addAll(unfixedFindingsToAdd);
        }
        return CodemodFileScanningResult.from(changes, unfixedFindings);
    }

    @NotNull
    private static <T> List<UnfixedFinding> createUnfixedFindingList(String path, DetectorRule detectorRule, Function<T, String> getKey, Function<T, Integer> getStartLine, List<T> issues) {
        return issues.stream().map(issue -> new UnfixedFinding((String)getKey.apply(issue), detectorRule, path, (Integer)getStartLine.apply(issue), "Ambiguous code shape")).toList();
    }
}

