/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.reflectioninjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.DependencyGAV;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.remediation.LegacyFixCandidate;
import io.codemodder.remediation.LegacyFixCandidateSearchResults;
import io.codemodder.remediation.LegacyFixCandidateSearcher;
import io.codemodder.remediation.MethodOrConstructor;
import io.codemodder.remediation.reflectioninjection.ReflectionInjectionRemediator;
import io.github.pixee.security.Reflection;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

final class DefaultReflectionInjectionRemediator
implements ReflectionInjectionRemediator {
    DefaultReflectionInjectionRemediator() {
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getStartLine, Function<T, Integer> getEndLine, Function<T, Integer> getStartColumn) {
        LegacyFixCandidateSearcher<T> searcher = new LegacyFixCandidateSearcher.Builder().withMatcher(mce -> DefaultReflectionInjectionRemediator.isClassForNameCall(cu, mce)).build();
        LegacyFixCandidateSearchResults results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getStartLine, getEndLine, getStartColumn);
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        for (LegacyFixCandidate legacyFixCandidate : results.fixCandidates()) {
            List issues = legacyFixCandidate.issues();
            int line = getStartLine.apply(issues.get(0));
            MethodCallExpr methodCallExpr = legacyFixCandidate.call().asMethodCall();
            DefaultReflectionInjectionRemediator.replaceMethodCallExpression(cu, methodCallExpr);
            issues.stream().map(getKey).forEach(id -> {
                CodemodChange change = CodemodChange.from(line, List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT), new FixedFinding(id, detectorRule));
                changes.add(change);
            });
        }
        return CodemodFileScanningResult.from(changes, results.unfixableFindings());
    }

    private static void replaceMethodCallExpression(CompilationUnit cu, MethodCallExpr methodCallExpr) {
        NameExpr name = new NameExpr(Reflection.class.getSimpleName());
        methodCallExpr.setScope((Expression)name);
        methodCallExpr.setName("loadAndVerify");
        ASTTransforms.addImportIfMissing(cu, Reflection.class);
    }

    private static boolean isClassForNameCall(CompilationUnit cu, MethodOrConstructor methodOrConstructor) {
        if (!methodOrConstructor.isMethodCall()) {
            return false;
        }
        MethodCallExpr methodCallExpr = methodOrConstructor.asMethodCall();
        boolean scopeMatches = methodCallExpr.getScope().map(expression -> {
            if (expression.isNameExpr()) {
                NameExpr nameExpr = expression.asNameExpr();
                return nameExpr.getNameAsString().equals("Class");
            }
            return false;
        }).orElse(cu.getImports().stream().anyMatch(importDeclaration -> importDeclaration.isStatic() && importDeclaration.getNameAsString().equals("java.lang.Class.forName")));
        boolean methodNameMatches = methodCallExpr.getNameAsString().equals("forName");
        return scopeMatches && methodNameMatches;
    }
}

