/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.sqlinjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.Either;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalVariableDeclaration;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.sqlinjection.SQLParameterizer;
import io.codemodder.remediation.sqlinjection.SQLParameterizerWithCleanup;
import io.codemodder.remediation.sqlinjection.SQLTableInjectionFilterTransform;
import java.util.Optional;

public final class SQLInjectionFixComposer
implements RemediationStrategy {
    private Optional<MethodCallExpr> flowsIntoExecuteCall(BinaryExpr binaryExpr) {
        Optional<MethodCallExpr> maybeDirectArgumentOfCall = ASTs.isArgumentOfMethodCall((Expression)binaryExpr).filter(SQLInjectionFixComposer::match);
        return maybeDirectArgumentOfCall.or(() -> this.isIndirectArgumentOfCall((Expression)binaryExpr));
    }

    private Optional<MethodCallExpr> isIndirectArgumentOfCall(Expression expr) {
        return ASTs.isInitExpr(expr).flatMap(LocalVariableDeclaration::fromVariableDeclarator).flatMap(lvd -> lvd.findAllReferences().flatMap(ne -> ASTs.isArgumentOfMethodCall((Expression)ne).stream()).filter(SQLInjectionFixComposer::match).findFirst());
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<Object> morb;
        if (node instanceof MethodCallExpr) {
            MethodCallExpr m = (MethodCallExpr)node;
            morb = Optional.of(Either.left(m));
        } else if (node instanceof BinaryExpr) {
            BinaryExpr b = (BinaryExpr)node;
            morb = Optional.of(Either.right(b));
        } else {
            morb = Optional.empty();
        }
        if (morb.isEmpty()) {
            return SuccessOrReason.reason("Neither a binary expression or method call");
        }
        Optional maybeCall = morb.flatMap(e -> e.ifLeftOrElseGet(Optional::of, this::flowsIntoExecuteCall));
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Could not find any execute call that the binary expr flows into");
        }
        MethodCallExpr methodCallExpr = (MethodCallExpr)maybeCall.get();
        Optional<MethodCallExpr> maybeFixed = new SQLParameterizer(methodCallExpr, cu).checkAndFix();
        if (maybeFixed.isPresent()) {
            SQLParameterizerWithCleanup.cleanup(maybeFixed.get());
            SQLTableInjectionFilterTransform.findAndFix(maybeFixed.get());
            return SuccessOrReason.success();
        }
        return SQLTableInjectionFilterTransform.findAndFix(methodCallExpr) ? SuccessOrReason.success() : SuccessOrReason.reason("Could not fix injection");
    }

    public static boolean match(Node node) {
        Optional<MethodCallExpr> maybeMethodCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null).filter(n -> SQLParameterizer.isSupportedJdbcMethodCall(n) || SQLTableInjectionFilterTransform.matchCall(n));
        return maybeMethodCall.isPresent();
    }
}

