/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xss;

import com.github.javaparser.ast.CompilationUnit;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.DependencyGAV;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.xss.NakedVariableReturnFixer;
import io.codemodder.remediation.xss.PrintingMethodFixer;
import io.codemodder.remediation.xss.XSSCodeShapeFixResult;
import io.codemodder.remediation.xss.XSSCodeShapeFixer;
import io.codemodder.remediation.xss.XSSFixGroup;
import io.codemodder.remediation.xss.XSSRemediator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DefaultXSSRemediator
implements XSSRemediator {
    private final List<XSSCodeShapeFixer> javaFixers = List.of(new PrintingMethodFixer(), new NakedVariableReturnFixer());

    DefaultXSSRemediator() {
    }

    @Override
    public <T> CodemodFileScanningResult remediateJava(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        List<XSSFixGroup<T>> fixGroups = this.createFixGroups(issuesForFile, getLine, getColumn);
        ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        for (XSSFixGroup<T> fixGroup : fixGroups) {
            boolean foundResponsibleFixer = false;
            for (XSSCodeShapeFixer javaFixer : this.javaFixers) {
                XSSCodeShapeFixResult fixResult = javaFixer.fixCodeShape(cu, path, detectorRule, fixGroup.issues(), getKey, getLine, getColumn);
                if (!fixResult.isResponsibleFixer()) continue;
                foundResponsibleFixer = true;
                if (fixResult.isFixed()) {
                    List<FixedFinding> fixes = fixGroup.issues().stream().map(fix -> new FixedFinding((String)getKey.apply(fix), detectorRule)).toList();
                    changes.add(CodemodChange.from(fixResult.line(), List.of(DependencyGAV.OWASP_XSS_JAVA_ENCODER), fixes));
                    break;
                }
                List<UnfixedFinding> unfixed = fixGroup.issues().stream().map(fix -> new UnfixedFinding((String)getKey.apply(fix), detectorRule, path, Integer.valueOf(fixResult.line()), fixResult.reasonNotFixed())).toList();
                unfixedFindings.addAll(unfixed);
                break;
            }
            if (foundResponsibleFixer) continue;
            unfixedFindings.addAll(fixGroup.issues().stream().map(fix -> new UnfixedFinding((String)getKey.apply(fix), detectorRule, path, (Integer)getLine.apply(fix), "Couldn't fix that shape of code")).toList());
        }
        return CodemodFileScanningResult.from(changes, unfixedFindings);
    }

    private <T> List<XSSFixGroup<T>> createFixGroups(List<T> issuesForFile, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        ArrayList<XSSFixGroup<T>> fixGroups = new ArrayList<XSSFixGroup<T>>();
        Map<Integer, List<T>> fixesPerLine = issuesForFile.stream().collect(Collectors.groupingBy(getLine));
        for (Map.Entry<Integer, List<T>> entry : fixesPerLine.entrySet()) {
            Map<Integer, List<T>> fixesPerColumn = entry.getValue().stream().collect(Collectors.groupingBy(getColumn));
            for (List<T> columnFixes : fixesPerColumn.values()) {
                fixGroups.add(new XSSFixGroup<T>(columnFixes));
            }
        }
        return List.copyOf(fixGroups);
    }

    @Override
    public <T> CodemodFileScanningResult remediateJSP(Path filePath, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        return CodemodFileScanningResult.none();
    }
}

