/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xss;

import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import io.codemodder.ast.ASTs;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.xss.XSSCodeShapeFixResult;
import io.codemodder.remediation.xss.XSSCodeShapeFixer;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

final class PrintingMethodFixer
implements XSSCodeShapeFixer {
    private static final Set<String> writingMethodNames = Set.of("print", "println", "write");

    PrintingMethodFixer() {
    }

    @Override
    public <T> XSSCodeShapeFixResult fixCodeShape(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issues, Function<T, String> getKey, Function<T, Integer> getLine, Function<T, Integer> getColumn) {
        int line = getLine.apply(issues.get(0));
        Integer column = getColumn.apply(issues.get(0));
        List<MethodCallExpr> writingMethodCalls = cu.findAll(MethodCallExpr.class).stream().filter(mce -> writingMethodNames.contains(mce.getNameAsString())).filter(mce -> mce.getArguments().size() == 1).filter(mce -> mce.getRange().isPresent()).filter(mce -> ((Range)mce.getRange().get()).begin.line == line).filter(mce -> column == null || ((Range)mce.getRange().get()).begin.column == column).filter(mce -> {
            Node patt2211$temp;
            NameExpr nameExpr;
            Optional<Node> source;
            Expression arg = mce.getArgument(0);
            if (arg instanceof NameExpr && (source = ASTs.findNonCallableSimpleNameSource((nameExpr = (NameExpr)arg).getName())).isPresent() && (patt2211$temp = source.get()) instanceof NodeWithType) {
                NodeWithType typedNode = (NodeWithType)patt2211$temp;
                String typeAsString = typedNode.getTypeAsString();
                return "String".equals(typeAsString) || "java.lang.String".equals(typeAsString);
            }
            return false;
        }).toList();
        if (writingMethodCalls.isEmpty()) {
            return new XSSCodeShapeFixResult(false, false, null, line);
        }
        if (writingMethodCalls.size() > 1) {
            return new XSSCodeShapeFixResult(true, false, "Multiple nodes found at the given location and that may cause confusion", line);
        }
        MethodCallExpr call = writingMethodCalls.get(0);
        JavaParserTransformer.wrap(call.getArgument(0)).withStaticMethod("org.owasp.encoder.Encode", "forHtml", false);
        return new XSSCodeShapeFixResult(true, true, null, line);
    }
}

