/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.LegacyFixCandidate;
import io.codemodder.remediation.LegacyFixCandidateSearchResults;
import io.codemodder.remediation.LegacyFixCandidateSearcher;
import io.codemodder.remediation.xxe.XMLFeatures;
import io.codemodder.remediation.xxe.XXEIntermediateXMLStreamReaderRemediator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

final class DefaultXXEIntermediateXMLStreamReaderRemediator
implements XXEIntermediateXMLStreamReaderRemediator {
    DefaultXXEIntermediateXMLStreamReaderRemediator() {
    }

    @Override
    public <T> CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getStartLine, Function<T, Integer> getEndLine, Function<T, Integer> getStartColumn) {
        LegacyFixCandidateSearcher<T> searcher = new LegacyFixCandidateSearcher.Builder().withMethodName("createXMLStreamReader").withMatcher(mce -> mce.asNode().hasScope()).withMatcher(mce -> mce.getArguments().isNonEmpty()).build();
        LegacyFixCandidateSearchResults results = searcher.search(cu, path, detectorRule, issuesForFile, getKey, getStartLine, getEndLine, getStartColumn);
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        for (LegacyFixCandidate legacyFixCandidate : results.fixCandidates()) {
            List issues = legacyFixCandidate.issues();
            MethodCallExpr createXMLStreamReaderCall = legacyFixCandidate.call().asMethodCall();
            Expression xmlStreamReaderScope = (Expression)createXMLStreamReaderCall.getScope().get();
            if (!xmlStreamReaderScope.isNameExpr()) {
                issues.stream().map(issue -> new UnfixedFinding((String)getKey.apply(issue), detectorRule, path, (Integer)getStartLine.apply(issue), "Could not find the XMLStreamReader variable")).forEach(unfixedFindings::add);
                continue;
            }
            NameExpr xmlStreamReaderVariable = xmlStreamReaderScope.asNameExpr();
            Optional ancestorStatement = createXMLStreamReaderCall.findAncestor(new Class[]{Statement.class});
            if (ancestorStatement.isEmpty()) {
                issues.stream().map(issue -> new UnfixedFinding((String)getKey.apply(issue), detectorRule, path, (Integer)getStartLine.apply(issue), "Could not find the statement containing the XMLStreamReader creation")).forEach(unfixedFindings::add);
                continue;
            }
            Statement stmt = (Statement)ancestorStatement.get();
            XMLFeatures.addXMLInputFactoryDisablingStatement(xmlStreamReaderVariable, stmt, true);
            issues.stream().map(issue -> CodemodChange.from((int)((Integer)getStartLine.apply(issue)), new FixedFinding((String)getKey.apply(issue), detectorRule))).forEach(changes::add);
        }
        unfixedFindings.addAll(results.unfixableFindings());
        return CodemodFileScanningResult.from(changes, unfixedFindings);
    }
}

