/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.xxe.XMLFeatures;
import io.codemodder.remediation.xxe.XXEFixAttempt;
import io.codemodder.remediation.xxe.XXEFixer;
import java.util.List;
import java.util.Optional;

final class DocumentBuilderFactoryAtNewDBFixer
implements XXEFixer {
    DocumentBuilderFactoryAtNewDBFixer() {
    }

    @Override
    public XXEFixAttempt tryFix(int line, Integer column, CompilationUnit cu) {
        List<MethodCallExpr> candidateMethods = ASTs.findMethodCallsWhichAreAssignedToType(cu, line, column, "newDocumentBuilder", List.of("DocumentBuilder"));
        if (candidateMethods.isEmpty()) {
            return new XXEFixAttempt(false, false, "No nodes at that location");
        }
        if (candidateMethods.size() > 1) {
            return new XXEFixAttempt(false, false, "Multiple nodes found at the given location and that may cause confusion");
        }
        MethodCallExpr newDocumentBuilderCall = candidateMethods.get(0);
        Optional newDocumentBuilderCallScope = newDocumentBuilderCall.getScope();
        if (newDocumentBuilderCallScope.isEmpty()) {
            return new XXEFixAttempt(true, false, "No scope found");
        }
        Expression scope = (Expression)newDocumentBuilderCallScope.get();
        if (!scope.isNameExpr()) {
            return new XXEFixAttempt(true, false, "Scope is not a name");
        }
        Optional statement = scope.findAncestor(new Class[]{Statement.class});
        if (statement.isEmpty()) {
            return new XXEFixAttempt(true, false, "No statement found");
        }
        return XMLFeatures.addFeatureDisablingStatements(scope.asNameExpr(), (Statement)statement.get(), true);
    }
}

