/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.xxe.XMLFeatures;
import io.codemodder.remediation.xxe.XXEFixAttempt;
import io.codemodder.remediation.xxe.XXEFixer;
import java.util.List;
import java.util.Optional;
import java.util.Set;

final class DocumentBuilderFactoryAtParseFixer
implements XXEFixer {
    DocumentBuilderFactoryAtParseFixer() {
    }

    @Override
    public XXEFixAttempt tryFix(int line, Integer column, CompilationUnit cu) {
        List<MethodCallExpr> candidateMethods = cu.findAll(MethodCallExpr.class).stream().filter(m -> "parse".equals(m.getNameAsString())).filter(m -> m.getScope().isPresent()).filter(m -> ((Expression)m.getScope().get()).isNameExpr()).filter(m -> m.getRange().isPresent() && ((Range)m.getRange().get()).begin.line == line).toList();
        if (candidateMethods.size() > 1 && column != null) {
            candidateMethods = candidateMethods.stream().filter(m -> ((Range)m.getRange().get()).contains(new Position(line, column.intValue()))).toList();
        }
        if (candidateMethods.isEmpty()) {
            return new XXEFixAttempt(false, false, "No nodes at that location");
        }
        if (candidateMethods.size() > 1) {
            return new XXEFixAttempt(false, false, "Multiple nodes found at the given location and that may cause confusion");
        }
        MethodCallExpr parseCall = candidateMethods.get(0);
        NameExpr documentBuilder = ((Expression)parseCall.getScope().get()).asNameExpr();
        Optional<MethodDeclaration> methodBody = ASTs.findMethodBodyFrom((Node)documentBuilder);
        if (methodBody.isEmpty()) {
            return new XXEFixAttempt(false, false, "No method body found for the call");
        }
        Optional<Node> documentBuilderAssignment = ASTs.findNonCallableSimpleNameSource(documentBuilder.getName());
        if (documentBuilderAssignment.isEmpty()) {
            return new XXEFixAttempt(false, false, "No assignment found for the DocumentBuilder");
        }
        Node parserAssignmentNode = documentBuilderAssignment.get();
        if (!(parserAssignmentNode instanceof NodeWithType)) {
            return new XXEFixAttempt(false, false, "Unknown DocumentBuilder assignment");
        }
        String parserType = ((NodeWithType)parserAssignmentNode).getTypeAsString();
        if (!Set.of("DocumentBuilder", "javax.xml.parsers.DocumentBuilder").contains(parserType)) {
            return new XXEFixAttempt(false, false, "Parsing method is not a DocumentBuilder");
        }
        if (parserAssignmentNode instanceof VariableDeclarator) {
            VariableDeclarator dbVar = (VariableDeclarator)parserAssignmentNode;
            Optional initializer = dbVar.getInitializer();
            if (initializer.isEmpty()) {
                return new XXEFixAttempt(false, false, "DocumentBuilder was not initialized in an expected way");
            }
            if (!(initializer.get() instanceof MethodCallExpr)) {
                return new XXEFixAttempt(false, false, "DocumentBuilder was not initialized with a factory call");
            }
            MethodCallExpr potentialFactoryCall = (MethodCallExpr)initializer.get();
            if (!"newDocumentBuilder".equals(potentialFactoryCall.getNameAsString())) {
                return new XXEFixAttempt(false, false, "DocumentBuilder was initialized with newDocumentBuilder");
            }
            if (potentialFactoryCall.getScope().isEmpty()) {
                return new XXEFixAttempt(true, false, "DocumentBuilder was initialized with a factory call without a scope");
            }
            if (!(potentialFactoryCall.getScope().get() instanceof NameExpr)) {
                return new XXEFixAttempt(false, false, "DocumentBuilder was initialized with a factory call with a non-name scope");
            }
            NameExpr factoryNameExpr = (NameExpr)potentialFactoryCall.getScope().get();
            Optional<Statement> newDocumentBuilderStatement = ASTs.findParentStatementFrom((Node)dbVar);
            if (newDocumentBuilderStatement.isEmpty()) {
                return new XXEFixAttempt(false, false, "DocumentBuilder was initialized with a factory call without a statement");
            }
            return XMLFeatures.addFeatureDisablingStatements(factoryNameExpr, newDocumentBuilderStatement.get(), true);
        }
        if (parserAssignmentNode instanceof Parameter) {
            return new XXEFixAttempt(true, false, "DocumentBuilder came from outside the method scope");
        }
        return new XXEFixAttempt(true, false, "DocumentBuilder was not initialized in an expected way");
    }
}

