/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.ast.ASTs;
import io.codemodder.javaparser.ASTExpectations;
import io.codemodder.remediation.xxe.XXEFixAttempt;
import io.codemodder.remediation.xxe.XXEFixer;
import java.util.List;
import java.util.Optional;

final class TransformerFactoryAtCreationFixer
implements XXEFixer {
    TransformerFactoryAtCreationFixer() {
    }

    @Override
    public XXEFixAttempt tryFix(int line, Integer column, CompilationUnit cu) {
        List<MethodCallExpr> candidateMethods = ASTs.findMethodCallsWhichAreAssignedToType(cu, line, column, "newInstance", List.of("TransformerFactory"));
        if (candidateMethods.isEmpty()) {
            return new XXEFixAttempt(false, false, "No nodes at that location");
        }
        if (candidateMethods.size() > 1) {
            return new XXEFixAttempt(false, false, "Multiple nodes found at the given location and that may cause confusion");
        }
        MethodCallExpr newFactoryInstanceCall = candidateMethods.get(0);
        Optional<VariableDeclarator> newFactoryVariableRef = ASTExpectations.expect((Node)newFactoryInstanceCall).toBeMethodCallExpression().initializingVariable().result();
        VariableDeclarator newFactoryVariable = newFactoryVariableRef.get();
        Optional variableDeclarationStmtRef = newFactoryVariable.findAncestor(new Class[]{Statement.class});
        if (variableDeclarationStmtRef.isEmpty()) {
            return new XXEFixAttempt(true, false, "Not assigned as part of statement");
        }
        Statement statement = (Statement)variableDeclarationStmtRef.get();
        Optional<BlockStmt> block = ASTs.findBlockStatementFrom((Node)statement);
        if (block.isEmpty()) {
            return new XXEFixAttempt(true, false, "No block statement found for newFactory() call");
        }
        BlockStmt blockStmt = block.get();
        MethodCallExpr setAttributeCall = new MethodCallExpr((Expression)newFactoryVariable.getNameAsExpression(), "setAttribute", NodeList.nodeList((Node[])new Expression[]{new FieldAccessExpr((Expression)new NameExpr("XMLConstants"), "ACCESS_EXTERNAL_DTD"), new StringLiteralExpr("")}));
        ASTTransforms.addImportIfMissing(cu, "javax.xml.XMLConstants");
        ExpressionStmt fixStatement = new ExpressionStmt((Expression)setAttributeCall);
        NodeList existingStatements = blockStmt.getStatements();
        int index = existingStatements.indexOf((Object)statement);
        existingStatements.add(index + 1, (Node)fixStatement);
        return new XXEFixAttempt(true, true, null);
    }
}

