/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.xxe.XMLFeatures;
import io.codemodder.remediation.xxe.XXEFixAttempt;
import io.codemodder.remediation.xxe.XXEFixer;
import java.util.List;
import java.util.Optional;
import java.util.Set;

final class XMLReaderAtParseFixer
implements XXEFixer {
    XMLReaderAtParseFixer() {
    }

    @Override
    public XXEFixAttempt tryFix(int line, Integer column, CompilationUnit cu) {
        List<MethodCallExpr> candidateMethods = cu.findAll(MethodCallExpr.class).stream().filter(m -> "parse".equals(m.getNameAsString())).filter(m -> m.getScope().isPresent()).filter(m -> ((Expression)m.getScope().get()).isNameExpr()).filter(m -> {
            Optional<Node> sourceRef = ASTs.findNonCallableSimpleNameSource(((Expression)m.getScope().get()).asNameExpr().getName());
            if (sourceRef.isEmpty()) {
                return false;
            }
            Node source = sourceRef.get();
            if (source instanceof NodeWithType) {
                return Set.of("XMLReader", "org.xml.sax.XMLReader").contains(((NodeWithType)source).getTypeAsString());
            }
            return false;
        }).filter(m -> m.getRange().isPresent()).filter(m -> ((Range)m.getRange().get()).begin.line == line).toList();
        if (column != null) {
            Position reportedPosition = new Position(line, column.intValue());
            candidateMethods = candidateMethods.stream().filter(m -> ((Range)m.getRange().get()).contains(reportedPosition)).toList();
        }
        if (candidateMethods.isEmpty()) {
            return new XXEFixAttempt(false, false, "No nodes at that location");
        }
        if (candidateMethods.size() > 1) {
            return new XXEFixAttempt(false, false, "Multiple nodes found at the given location and that may cause confusion");
        }
        MethodCallExpr parseCall = candidateMethods.get(0);
        Optional parserRef = parseCall.getScope();
        if (parserRef.isEmpty()) {
            return new XXEFixAttempt(false, false, "No scope found for parse() call");
        }
        if (!((Expression)parserRef.get()).isNameExpr()) {
            return new XXEFixAttempt(false, false, "Scope is not a name expression");
        }
        NameExpr parser = ((Expression)parserRef.get()).asNameExpr();
        Optional parseStatement = parseCall.findAncestor(new Class[]{Statement.class});
        if (parseStatement.isEmpty()) {
            return new XXEFixAttempt(true, false, "No statement found for parse() call");
        }
        return XMLFeatures.addFeatureDisablingStatements(parser.asNameExpr(), (Statement)parseStatement.get(), true);
    }
}

