/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.Line;
import java.util.Objects;

final class DefaultLine
implements Line {
    private final int number;
    private final String content;

    DefaultLine(int number, String content) {
        if (number <= 0) {
            throw new IllegalArgumentException("Line number must be positive");
        }
        this.number = number;
        this.content = Objects.requireNonNull(content);
    }

    @Override
    public int number() {
        return this.number;
    }

    @Override
    public String content() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLine that = (DefaultLine)o;
        if (this.number != that.number) {
            return false;
        }
        return this.content.equals(that.content);
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + this.content.hashCode();
        return result;
    }
}

