/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.javaparser.CallReplacer;
import java.util.Objects;
import java.util.Optional;

final class DefaultCallReplacer
implements CallReplacer {
    private final Expression call;
    private final NodeList<Expression> arguments;

    DefaultCallReplacer(Expression expression) {
        if (!(expression instanceof NodeWithArguments)) {
            throw new IllegalArgumentException("Expression must be a NodeWithArguments");
        }
        this.call = Objects.requireNonNull(expression);
        this.arguments = ((NodeWithArguments)expression).getArguments();
    }

    @Override
    public CallReplacer.CallReplacerBuilder withStaticMethod(String className, String methodName) {
        return new DefaultCallReplacerBuilder(className, methodName);
    }

    @Override
    public void withExpression(Expression expression) {
        Node parent = (Node)this.call.getParentNode().get();
        parent.replace((Node)this.call, (Node)expression);
    }

    private class DefaultCallReplacerBuilder
    implements CallReplacer.CallReplacerBuilder {
        private final String className;
        private final String methodName;
        private boolean useStaticImport;

        private DefaultCallReplacerBuilder(String className, String methodName) {
            this.className = Objects.requireNonNull(className);
            this.methodName = Objects.requireNonNull(methodName);
            this.useStaticImport = false;
        }

        @Override
        public CallReplacer.CallReplacerBuilder withStaticImport() {
            this.useStaticImport = true;
            return this;
        }

        @Override
        public boolean withNewArguments(NodeList<Expression> newArguments) {
            return this.transform(this.className, this.methodName, this.useStaticImport, newArguments);
        }

        @Override
        public boolean withSameArguments() {
            return this.transform(this.className, this.methodName, this.useStaticImport, DefaultCallReplacer.this.arguments);
        }

        private boolean transform(String className, String methodName, boolean isStaticImport, NodeList<Expression> newArguments) {
            Optional cu = DefaultCallReplacer.this.call.findCompilationUnit();
            if (cu.isEmpty()) {
                return false;
            }
            Node parent = (Node)DefaultCallReplacer.this.call.getParentNode().get();
            String simpleName = className.substring(className.lastIndexOf(46) + 1);
            MethodCallExpr safeCall = isStaticImport ? new MethodCallExpr(methodName, (Expression[])newArguments.toArray((Object[])new Expression[0])) : new MethodCallExpr((Expression)new NameExpr(simpleName), methodName, newArguments);
            parent.replace((Node)DefaultCallReplacer.this.call, (Node)safeCall);
            if (isStaticImport) {
                ASTTransforms.addStaticImportIfMissing((CompilationUnit)cu.get(), className + "." + methodName);
            } else {
                ASTTransforms.addImportIfMissing((CompilationUnit)cu.get(), className);
            }
            return true;
        }
    }
}

