/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.nodeTypes.NodeWithRange;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.codetf.UnfixedFinding;
import io.codemodder.remediation.DefaultNodePositionMatcher;
import io.codemodder.remediation.FixCandidate;
import io.codemodder.remediation.FixCandidateSearchResults;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.NodePositionMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.VisibleForTesting;

final class DefaultFixCandidateSearcher<T>
implements FixCandidateSearcher<T> {
    private final List<Predicate<Node>> matchers;
    private final NodePositionMatcher nodePositionMatcher;

    DefaultFixCandidateSearcher(List<Predicate<Node>> matchers) {
        this.matchers = matchers;
        this.nodePositionMatcher = new DefaultNodePositionMatcher();
    }

    DefaultFixCandidateSearcher(List<Predicate<Node>> matchers, NodePositionMatcher nodePositionMatcher) {
        this.matchers = matchers;
        this.nodePositionMatcher = nodePositionMatcher;
    }

    @Override
    public FixCandidateSearchResults<T> search(CompilationUnit cu, String path, DetectorRule rule, final List<T> issuesForFile, Function<T, String> getKey, Function<T, Integer> getStartLine, Function<T, Optional<Integer>> getEndLine, Function<T, Optional<Integer>> getColumn) {
        final ArrayList<UnfixedFinding> unfixedFindings = new ArrayList<UnfixedFinding>();
        List<Node> nodes = cu.findAll(Node.class).stream().filter(n -> this.matchers.stream().allMatch(m -> m.test(n))).toList();
        IdentityHashMap<Node, List> fixCandidateToIssueMapping = new IdentityHashMap<Node, List>();
        final HashSet<T> matchedIssues = new HashSet<T>();
        for (T issue : issuesForFile) {
            String findingId = getKey.apply(issue);
            int issueStartLine = getStartLine.apply(issue);
            int issueEndLine = getEndLine.apply(issue).orElse(issueStartLine);
            Optional<Integer> maybeColumn = getColumn.apply(issue);
            List<Node> nodesForIssue = nodes.stream().filter(NodeWithRange::hasRange).filter(n -> maybeColumn.map(column -> this.nodePositionMatcher.match((Node)n, issueStartLine, issueEndLine, (int)column)).orElse(this.nodePositionMatcher.match((Node)n, issueStartLine, issueEndLine))).toList();
            if (nodesForIssue.isEmpty()) continue;
            matchedIssues.add(issue);
            if (nodesForIssue.size() > 1) {
                unfixedFindings.add(new UnfixedFinding(findingId, rule, path, Integer.valueOf(issueStartLine), "Multiple nodes found at the given location and that may cause confusion"));
                continue;
            }
            Node node = nodesForIssue.get(0);
            fixCandidateToIssueMapping.computeIfAbsent(node, k -> new ArrayList()).add(issue);
        }
        final List<FixCandidate> fixCandidates = fixCandidateToIssueMapping.entrySet().stream().map(entry -> new FixCandidate((Node)entry.getKey(), (List)entry.getValue())).toList();
        return new FixCandidateSearchResults<T>(){

            @Override
            public List<UnfixedFinding> unfixableFindings() {
                return unfixedFindings;
            }

            @Override
            public List<T> unmatchedIssues() {
                return issuesForFile.stream().filter(i -> !matchedIssues.contains(i)).toList();
            }

            @Override
            public List<FixCandidate<T>> fixCandidates() {
                return fixCandidates;
            }
        };
    }

    @VisibleForTesting
    static boolean matches(int issueStartLine, int startNodeLine, int issueEndLine) {
        return DefaultFixCandidateSearcher.isInBetween(startNodeLine, issueStartLine, issueEndLine);
    }

    static boolean matches(int issueStartLine, int startNodeLine) {
        return startNodeLine == issueStartLine;
    }

    private static boolean isInBetween(int number, int lowerBound, int upperBound) {
        return number >= lowerBound && number <= upperBound;
    }
}

