/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.missingsecureflag;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.util.Optional;

final class FixAtJakartaAddCookieCallStrategy
implements RemediationStrategy {
    FixAtJakartaAddCookieCallStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<MethodCallExpr> maybeCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null).filter(Node::hasScope);
        if (maybeCall.isPresent()) {
            MethodCallExpr methodCallExpr = maybeCall.get();
            Optional<Statement> maybeStmt = methodCallExpr.getParentNode().map(p -> p instanceof Statement ? (Statement)p : null).filter(Statement::isExpressionStmt);
            if (maybeStmt.isEmpty()) {
                return SuccessOrReason.reason("Could not find expression statement containing call");
            }
            Optional<Expression> maybeCookieExpression = methodCallExpr.getArguments().stream().findFirst().filter(expr -> expr.isNameExpr() || expr.isFieldAccessExpr());
            if (maybeCookieExpression.isEmpty()) {
                return SuccessOrReason.reason("First argument is not a name or field access expression");
            }
            ExpressionStmt newStatement = new ExpressionStmt((Expression)new MethodCallExpr(maybeCookieExpression.get(), "setSecure", new NodeList((Node[])new Expression[]{new BooleanLiteralExpr(true)})));
            ASTTransforms.addStatementBeforeStatement(maybeStmt.get(), (Statement)newStatement);
            return SuccessOrReason.success();
        }
        return SuccessOrReason.reason("Not a method call with scope.");
    }
}

