/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.reflectioninjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.Remediator;
import io.codemodder.remediation.SearcherStrategyRemediator;
import io.codemodder.remediation.reflectioninjection.ReflectionInjectionFixStrategy;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

public final class ReflectionInjectionRemediator<T>
implements Remediator<T> {
    private final SearcherStrategyRemediator<T> searchStrategyRemediator = new SearcherStrategyRemediator.Builder().withSearcherStrategyPair(new FixCandidateSearcher.Builder().withMatcher(node -> Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null).filter(ReflectionInjectionRemediator::isClassForNameCall).isPresent()).build(), new ReflectionInjectionFixStrategy()).build();

    @Override
    public CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, Collection<T> findingsForPath, Function<T, String> findingIdExtractor, Function<T, Integer> findingStartLineExtractor, Function<T, Optional<Integer>> findingEndLineExtractor, Function<T, Optional<Integer>> findingColumnExtractor) {
        return this.searchStrategyRemediator.remediateAll(cu, path, detectorRule, findingsForPath, findingIdExtractor, findingStartLineExtractor, findingEndLineExtractor, findingColumnExtractor);
    }

    private static boolean isClassForNameCall(MethodCallExpr methodCallExpr) {
        Optional maybeCU = methodCallExpr.findCompilationUnit();
        if (maybeCU.isEmpty()) {
            return false;
        }
        CompilationUnit cu = (CompilationUnit)maybeCU.get();
        boolean scopeMatches = methodCallExpr.getScope().map(expression -> {
            if (expression.isNameExpr()) {
                NameExpr nameExpr = expression.asNameExpr();
                return nameExpr.getNameAsString().equals("Class");
            }
            return false;
        }).orElse(cu.getImports().stream().anyMatch(importDeclaration -> importDeclaration.isStatic() && importDeclaration.getNameAsString().equals("java.lang.Class.forName")));
        boolean methodNameMatches = methodCallExpr.getNameAsString().equals("forName");
        return scopeMatches && methodNameMatches;
    }
}

