/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.regexinjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.ast.ASTs;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.Remediator;
import io.codemodder.remediation.SearcherStrategyRemediator;
import io.codemodder.remediation.SuccessOrReason;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class RegexInjectionRemediator<T>
implements Remediator<T> {
    private final SearcherStrategyRemediator<T> searchStrategyRemediator = new SearcherStrategyRemediator.Builder().withSearcherStrategyPair(new FixCandidateSearcher.Builder().withMatcher(node -> Optional.of(node).map(n -> {
        Expression e;
        return n instanceof Expression ? (e = (Expression)n) : null;
    }).flatMap(ASTs::isArgumentOfMethodCall).filter(RegexInjectionRemediator::isCompileCall).isPresent()).build(), new FixPatternCompileStrategy()).withSearcherStrategyPair(new FixCandidateSearcher.Builder().withMatcher(node -> Optional.of(node).map(n -> {
        Expression e;
        return n instanceof Expression ? (e = (Expression)n) : null;
    }).flatMap(e -> ASTs.isArgumentOfMethodCall(e).filter(mce -> mce.getArgument(0) == e)).filter(RegexInjectionRemediator::isReplaceFirstCall).isPresent()).build(), new FixStringReplaceFirstStrategy()).build();

    private static boolean isCompileCall(MethodCallExpr methodCallExpr) {
        return "compile".equals(methodCallExpr.getNameAsString()) && (methodCallExpr.getArguments().size() == 1 || methodCallExpr.getArguments().size() == 2 && !((Expression)methodCallExpr.getArguments().get(0)).isStringLiteralExpr());
    }

    private static boolean isReplaceFirstCall(MethodCallExpr methodCallExpr) {
        return methodCallExpr.getNameAsString().equals("replaceFirst") && methodCallExpr.getArguments().size() == 2 && !((Expression)methodCallExpr.getArguments().get(0)).isStringLiteralExpr();
    }

    @Override
    public CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, Collection<T> findingsForPath, Function<T, String> findingIdExtractor, Function<T, Integer> findingStartLineExtractor, Function<T, Optional<Integer>> findingEndLineExtractor, Function<T, Optional<Integer>> findingColumnExtractor) {
        return this.searchStrategyRemediator.remediateAll(cu, path, detectorRule, findingsForPath, findingIdExtractor, findingStartLineExtractor, findingEndLineExtractor, findingColumnExtractor);
    }

    private static class FixPatternCompileStrategy
    implements RemediationStrategy {
        private FixPatternCompileStrategy() {
        }

        @Override
        public SuccessOrReason fix(CompilationUnit cu, Node node) {
            MethodCallExpr compileCall = ASTs.isArgumentOfMethodCall((Expression)node).get();
            Expression argument = compileCall.getArgument(0);
            JavaParserTransformer.wrap(argument).withStaticMethod(Pattern.class.getName(), "quote", false);
            return SuccessOrReason.success();
        }
    }

    private static class FixStringReplaceFirstStrategy
    implements RemediationStrategy {
        private FixStringReplaceFirstStrategy() {
        }

        @Override
        public SuccessOrReason fix(CompilationUnit cu, Node node) {
            MethodCallExpr replaceFirstCall = ASTs.isArgumentOfMethodCall((Expression)node).get();
            Expression argument = replaceFirstCall.getArgument(0);
            JavaParserTransformer.wrap(argument).withStaticMethod(Pattern.class.getName(), "quote", false);
            return SuccessOrReason.success();
        }
    }
}

