/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xss;

import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import io.codemodder.DependencyGAV;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.SuccessOrReason;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

final class EncoderWrapping {
    private EncoderWrapping() {
    }

    @NotNull
    static SuccessOrReason fix(NodeWithArguments<?> argument, int index) {
        Optional<Expression> thingToWrap = EncoderWrapping.findExpressionToWrap(argument.getArgument(index));
        if (thingToWrap.isEmpty()) {
            return SuccessOrReason.reason("Could not find recognize code shape to fix.");
        }
        EncoderWrapping.wrapExpression(thingToWrap.get());
        return SuccessOrReason.success(List.of(DependencyGAV.OWASP_XSS_JAVA_ENCODER));
    }

    private static Optional<Expression> findExpressionToWrap(Expression expression) {
        if (expression.isNameExpr()) {
            return Optional.of(expression);
        }
        if (expression.isBinaryExpr()) {
            BinaryExpr binaryExpr = expression.asBinaryExpr();
            if (binaryExpr.getLeft().isBinaryExpr() && binaryExpr.getRight().isStringLiteralExpr()) {
                BinaryExpr leftBinaryExpr = binaryExpr.getLeft().asBinaryExpr();
                if (leftBinaryExpr.getLeft().isStringLiteralExpr() && !leftBinaryExpr.getRight().isStringLiteralExpr()) {
                    return Optional.of(leftBinaryExpr.getRight());
                }
            } else {
                if (binaryExpr.getLeft().isStringLiteralExpr() && binaryExpr.getRight().isStringLiteralExpr()) {
                    return Optional.empty();
                }
                if (binaryExpr.getLeft().isStringLiteralExpr()) {
                    return Optional.of(binaryExpr.getRight());
                }
                if (binaryExpr.getRight().isStringLiteralExpr()) {
                    return Optional.of(binaryExpr.getLeft());
                }
            }
        }
        return Optional.empty();
    }

    private static void wrapExpression(Expression expressionToWrap) {
        JavaParserTransformer.wrap(expressionToWrap).withStaticMethod("org.owasp.encoder.Encode", "forHtml", false);
    }
}

