/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xss;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.resolution.types.ResolvedType;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.xss.EncoderWrapping;
import java.util.Optional;

final class ResponseEntityConstructorFixStrategy
implements RemediationStrategy {
    ResponseEntityConstructorFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<ObjectCreationExpr> maybeCall = Optional.of(node).map(n -> n instanceof ObjectCreationExpr ? (ObjectCreationExpr)n : null);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call.");
        }
        ObjectCreationExpr call = maybeCall.get();
        return EncoderWrapping.fix(call, 0);
    }

    static boolean match(Node node) {
        return Optional.of(node).map(n -> n instanceof ObjectCreationExpr ? (ObjectCreationExpr)n : null).filter(c -> "ResponseEntity".equals(c.getTypeAsString()) || c.getTypeAsString().startsWith("ResponseEntity<")).filter(c -> !c.getArguments().isEmpty()).filter(c -> {
            Expression firstArg = (Expression)c.getArguments().getFirst().get();
            try {
                ResolvedType resolvedType = firstArg.calculateResolvedType();
                return "java.lang.String".equals(resolvedType.describe());
            }
            catch (Exception e) {
                return false;
            }
        }).isPresent();
    }
}

