/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.MatchAndFixStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.xxe.XMLFixBuilder;
import java.util.List;
import java.util.Optional;

final class DocumentBuilderFactoryAtNewDBFixStrategy
extends MatchAndFixStrategy {
    DocumentBuilderFactoryAtNewDBFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Expression scope;
        Optional<MethodCallExpr> maybeCall = Optional.of(node).map(m -> m instanceof MethodCallExpr ? (MethodCallExpr)node : null);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call");
        }
        MethodCallExpr newDocumentBuilderCall = maybeCall.get();
        Optional newDocumentBuilderCallScope = newDocumentBuilderCall.getScope();
        if (newDocumentBuilderCallScope.isEmpty()) {
            SuccessOrReason.reason("No scope found");
        }
        if (!(scope = (Expression)newDocumentBuilderCallScope.get()).isNameExpr()) {
            return SuccessOrReason.reason("Scope is not a name");
        }
        Optional statement = scope.findAncestor(new Class[]{Statement.class});
        if (statement.isEmpty()) {
            return SuccessOrReason.reason("No statement found");
        }
        return XMLFixBuilder.addFeatureDisablingStatements(scope.asNameExpr(), (Statement)statement.get(), true);
    }

    @Override
    public boolean match(Node node) {
        return ASTs.isInitializedToType(node, "newDocumentBuilder", List.of("DocumentBuilder")).isPresent();
    }
}

